/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.SalesHeader;
import classes.ShopLocation;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import impl.org.controlsfx.tools.PrefixSelectionCustomizer;
import java.net.URL;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.MapValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class SalesOrderController
implements Initializable {
    private User user;
    private SalesHeader header;
    private String docType;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private Label docNo;
    @FXML
    private Label requestDate;
    @FXML
    private Label customerName;
    @FXML
    private ComboBox<ShopLocation> warehouse;
    @FXML
    private ComboBox<User> vsm;
    @FXML
    private TableView<HashMap> allEntries;
    @FXML
    private TableColumn colItemCode;
    @FXML
    private TableColumn colItemName;
    @FXML
    private TableColumn colRequestedQuantity;
    @FXML
    private TableColumn colIssuedQuantity;
    @FXML
    private TableColumn colAvailableQuantity;
    @FXML
    private MaskerPane masker;
    @FXML
    private Button cancel;
    @FXML
    private Button approve;
    @FXML
    private HBox approvalHbox;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public SalesHeader getHeader() {
        return this.header;
    }

    public void setHeader(SalesHeader header) {
        this.header = header;
        this.docNo.setText(header.getDoc_no());
        this.requestDate.setText(header.getSales_date());
        try {
            this.customerName.setText(header.getCustomer().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.warehouse.setValue((Object)header.getLocation());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.vsm.setValue((Object)header.getSalesRep());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadLines();
        if (header.getStatus().equalsIgnoreCase("Approved")) {
            this.approvalHbox.setVisible(false);
        } else {
            this.loadWarehouse();
            this.loadVSM();
        }
    }

    private void loadVSM() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    SalesOrderController.this.notificationPane.setText("Loading VSM. Please wait");
                    SalesOrderController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    SalesOrderController.this.notificationPane.show();
                });
                ObservableList<User> allUsers = new User().getAllUsers(true, SalesOrderController.this.getUser());
                allUsers.sort(Comparator.comparing(User::getFullName));
                Platform.runLater(() -> {
                    SalesOrderController.this.notificationPane.hide();
                    SalesOrderController.this.vsm.setItems(allUsers);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadWarehouse() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    SalesOrderController.this.notificationPane.setText("Loading VSM. Please wait");
                    SalesOrderController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    SalesOrderController.this.notificationPane.show();
                });
                ObservableList<ShopLocation> allLocations = new ShopLocation().getAllLocations(SalesOrderController.this.getUser());
                allLocations.sort(Comparator.comparing(ShopLocation::getName));
                Platform.runLater(() -> {
                    SalesOrderController.this.notificationPane.hide();
                    SalesOrderController.this.warehouse.setItems(allLocations);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public String getDocType() {
        return this.docType;
    }

    public void setDocType(String docType) {
        this.docType = docType;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        PrefixSelectionCustomizer.customize(this.vsm);
        PrefixSelectionCustomizer.customize(this.warehouse);
        this.approvalHbox.managedProperty().bind((ObservableValue)this.approvalHbox.visibleProperty());
        Callback numberFormatCellFactoryForMap = p -> new TextFieldTableCell(new StringConverter(){

            public String toString(Object t) {
                try {
                    return Config.formatNumber(Double.parseDouble(t.toString()));
                }
                catch (Exception u) {
                    return t.toString();
                }
            }

            public Object fromString(String string) {
                return null;
            }
        });
        Callback<TableColumn<HashMap, HashMap>, TableCell<HashMap, HashMap>> cellFactory = new Callback<TableColumn<HashMap, HashMap>, TableCell<HashMap, HashMap>>(){

            public TableCell<HashMap, HashMap> call(TableColumn<HashMap, HashMap> param) {
                TableCell<HashMap, HashMap> cell = new TableCell<HashMap, HashMap>(){
                    private final Hyperlink btn = new Hyperlink("Edit");
                    {
                        this.btn.setOnAction(e -> {
                            this.btn.setVisited(false);
                            HashMap data = (HashMap)this.getTableView().getItems().get(this.getIndex());
                            String requestedQuantity = data.get("requested_quantity").toString();
                            String itemType = data.get("itemType").toString();
                            String itemNo = data.get("itemNo").toString();
                            String lineId = data.get("lineId").toString();
                            TextInputDialog alert = new TextInputDialog(requestedQuantity);
                            alert.setHeaderText(null);
                            alert.setTitle("Edit Approved Quantity");
                            alert.setContentText("Edit Approved Quantity");
                            Optional result = alert.showAndWait();
                            result.ifPresent(issuedQuantity -> SalesOrderController.this.editIssuedQuantity(requestedQuantity, (String)issuedQuantity, itemType, itemNo, lineId));
                        });
                    }

                    public void updateItem(HashMap item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            Double issuedQuantity = Double.parseDouble(item.get("issued_quantity").toString());
                            this.btn.setText(Config.formatNumber(issuedQuantity));
                            this.setGraphic((Node)this.btn);
                        }
                    }
                };
                return cell;
            }
        };
        this.colIssuedQuantity.setCellFactory((Callback)cellFactory);
        this.colIssuedQuantity.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        this.colItemCode.setCellValueFactory((Callback)new MapValueFactory((Object)"itemNo"));
        this.colItemName.setCellValueFactory((Callback)new MapValueFactory((Object)"description"));
        this.colRequestedQuantity.setCellValueFactory((Callback)new MapValueFactory((Object)"requested_quantity"));
        this.colAvailableQuantity.setCellValueFactory((Callback)new MapValueFactory((Object)"available_quantity"));
        this.colRequestedQuantity.setCellFactory(numberFormatCellFactoryForMap);
        this.colAvailableQuantity.setCellFactory(numberFormatCellFactoryForMap);
        this.cancel.setOnAction(e -> ((Stage)this.cancel.getScene().getWindow()).close());
        this.vsm.setOnAction(e -> {
            try {
                this.warehouse.setValue((Object)((User)this.vsm.getValue()).getWarehouse());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.approve.setOnAction(e -> {
            this.approve.setDisable(true);
            if (Config.showConfirmDialog("Post Sales Order", "Posting the Sales Order will result in a change in Stock Levels.", "Are you sure you want to post the Sales Order?")) {
                try {
                    String tWarehouse = "";
                    String tVsm = "";
                    try {
                        tWarehouse = ((ShopLocation)this.warehouse.getValue()).getId() + "";
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        tVsm = ((User)this.vsm.getValue()).getUserName() + "";
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    HashMap<String, Object> convertParams = new HashMap<String, Object>();
                    String desired = "StockRequest";
                    convertParams.put("docNo", this.docNo.getText().trim());
                    convertParams.put("currentDocumentType", this.getDocType());
                    convertParams.put("desiredDocumentType", desired);
                    convertParams.put("warehouse", tWarehouse);
                    convertParams.put("vsm", tVsm);
                    String convertResponse = Config.loadDataFromPhp("mastercreate?type=convert_sales_header", convertParams, this.getUser());
                    System.out.println(convertResponse);
                    Gson gson = new Gson();
                    JsonResponses jr1 = (JsonResponses)gson.fromJson(convertResponse, JsonResponses.class);
                    if (jr1.isStatus()) {
                        String stockRequestNo = jr1.getOverLoad1();
                        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                        params.put("docNo", stockRequestNo);
                        params.put("docType", desired);
                        String response = Config.loadDataFromPhp("masterpost?type=salesheader", params, this.getUser());
                        System.out.println(response);
                        JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                        if (jr.isStatus()) {
                            LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                            reportVariables.put("saccoName", Config.saccoName);
                            reportVariables.put("reportName", "Stock Request");
                            reportVariables.put("docNo", stockRequestNo);
                            reportVariables.put("docDate", this.requestDate.getText().trim());
                            reportVariables.put("vsm", ((User)this.vsm.getValue()).getFullName().trim());
                            reportVariables.put("approvedBy", this.user.getFullName());
                            reportVariables.put("customer", this.header.getCustomer().getCustomerName());
                            reportVariables.put("reference", this.header.getReference());
                            LinkedHashMap<String, Object> params2 = new LinkedHashMap<String, Object>();
                            params2.put("docNo", stockRequestNo);
                            params2.put("docType", desired);
                            new Config().getReport("Stock Request", "masterfetch?type=salesline", params2, "stockrequest.jasper", reportVariables, this.user);
                            GeneralListController.publicNotificationPane.setText(jr.getMessage());
                            GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                            GeneralListController.publicNotificationPane.show();
                            ((Stage)this.cancel.getScene().getWindow()).close();
                            return;
                        }
                        try {
                            Boolean requestManagement = (Boolean)new Gson().fromJson(jr.getOverLoad1(), Boolean.class);
                            if (!requestManagement.booleanValue()) throw new Exception();
                            if (!Config.showConfirmDialog("Request Management Approval", "Request management Approval", jr.getMessage())) return;
                            LinkedHashMap<String, String> params2 = new LinkedHashMap<String, String>();
                            params2.put("document_type", "StockTake");
                            params2.put("date", jr.getOverLoad2());
                            params2.put("rejectionReason", jr.getMessage());
                            String response2 = Config.loadDataFromPhp("mastercreate?type=stock_management_approval", params, this.getUser());
                            JsonResponses jr2 = (JsonResponses)new Gson().fromJson(response2, JsonResponses.class);
                            this.notificationPane.setText(jr2.getMessage());
                            this.notificationPane.setGraphic((Node)jr2.getIconFromStatus());
                            this.notificationPane.show();
                            return;
                        }
                        catch (Exception ignored) {
                            this.notificationPane.setText(jr.getMessage());
                            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                            this.notificationPane.show();
                        }
                        return;
                    }
                    this.notificationPane.setText(jr1.getMessage());
                    this.notificationPane.setGraphic((Node)jr1.getIconFromStatus());
                    this.notificationPane.show();
                    return;
                }
                catch (Exception u) {
                    u.printStackTrace();
                    this.notificationPane.setText("We encountered an error while processing your request");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                    return;
                }
                finally {
                    this.approve.setDisable(false);
                }
            }
            this.approve.setDisable(false);
        });
    }

    public void loadLines() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> SalesOrderController.this.masker.setVisible(true));
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("docNo", SalesOrderController.this.docNo.getText().trim());
                    params.put("docType", SalesOrderController.this.getDocType());
                    String response = Config.loadDataFromPhp("masterfetch?type=salesline", params, SalesOrderController.this.getUser());
                    System.out.println(response);
                    ObservableList allLines = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, HashMap[].class)));
                    Platform.runLater(() -> {
                        SalesOrderController.this.allEntries.setItems(allLines);
                        SalesOrderController.this.masker.setVisible(false);
                    });
                }
                catch (Exception u) {
                    u.printStackTrace();
                }
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void editIssuedQuantity(String requestedQuantity, String issuedQuantity, String itemType, String itemNo, String lineId) {
        this.notificationPane.setText("Editing Quantity. Please wait....");
        this.notificationPane.setGraphic((Node)new ProgressIndicator());
        this.notificationPane.show();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("headerNo", this.docNo.getText().trim());
            params.put("documentType", this.getDocType());
            params.put("documentType", this.getDocType());
            params.put("itemType", itemType);
            params.put("itemNo", itemNo);
            params.put("requestedQuantity", requestedQuantity);
            params.put("issuedQuantity", issuedQuantity);
            params.put("quantity", issuedQuantity);
            params.put("lineId", lineId);
            String response = Config.loadDataFromPhp("masterupdate?type=salesline", params, this.getUser());
            Gson g = new Gson();
            JsonResponses js = (JsonResponses)g.fromJson(response, JsonResponses.class);
            if (js.isStatus()) {
                this.loadLines();
                this.notificationPane.setText(js.getMessage());
                this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                this.notificationPane.show();
            } else {
                this.notificationPane.setText(js.getMessage());
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        }
        catch (Exception u) {
            this.notificationPane.setText("We experienced an error while editing the quantity. Please try again later. ");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }
}

