/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Account;
import classes.Config;
import classes.GLEntry;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;

public class ShowGLEntries
implements Initializable {
    private User user;
    @FXML
    private TableView<GLEntry> allEntries;
    @FXML
    private TableColumn id;
    @FXML
    private TableColumn docNo;
    @FXML
    private TableColumn extDocNo;
    @FXML
    private TableColumn transactionDate;
    @FXML
    private TableColumn description;
    @FXML
    private TableColumn debit;
    @FXML
    private TableColumn credit;
    @FXML
    private TableColumn balance;
    @FXML
    private TableColumn postedBy;
    @FXML
    private HBox filterLabel;
    @FXML
    Label showFilter;
    @FXML
    MaskerPane masker;
    @FXML
    private ComboBox<Account> allAccounts;
    private Account glAccount;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.allAccounts.setItems(Account.getAccounts(this.getUser()));
    }

    public Account getGlAccount() {
        return this.glAccount;
    }

    public void setGlAccount(Account glAccount) {
        this.glAccount = glAccount;
        this.allAccounts.setValue((Object)glAccount);
        this.showFilter.setText("G/L Ledger Entries for G/L Account Name: " + glAccount.getAccountName() + " Code: " + glAccount.getAccountNumber());
        this.showEntries();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.id.setCellValueFactory((Callback)new PropertyValueFactory("TransactionId"));
        this.docNo.setCellValueFactory((Callback)new PropertyValueFactory("DocumentNumber"));
        this.extDocNo.setCellValueFactory((Callback)new PropertyValueFactory("ExternalDocumentNumber"));
        this.transactionDate.setCellValueFactory((Callback)new PropertyValueFactory("TransactionDateTime"));
        this.description.setCellValueFactory((Callback)new PropertyValueFactory("Description"));
        this.debit.setCellValueFactory((Callback)new PropertyValueFactory("debitString"));
        this.credit.setCellValueFactory((Callback)new PropertyValueFactory("creditString"));
        this.balance.setCellValueFactory((Callback)new PropertyValueFactory("balanceString"));
        this.postedBy.setCellValueFactory((Callback)new PropertyValueFactory("PostedBy"));
        this.allAccounts.setOnAction(e -> {
            this.showFilter.setText("G/L Ledger Entries for G/L Account Name: " + ((Account)this.allAccounts.getValue()).getAccountName() + " Code: " + ((Account)this.allAccounts.getValue()).getAccountNumber());
            this.showEntries();
        });
    }

    public void showEntries() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                try {
                    Platform.runLater(() -> ShowGLEntries.this.masker.setVisible(true));
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("accountNumber", ((Account)ShowGLEntries.this.allAccounts.getValue()).getAccountNumber());
                    String response = Config.loadDataFromPhp("masterfetch?type=glentries", params, ShowGLEntries.this.getUser());
                    Gson g = new Gson();
                    Object[] response2 = (GLEntry[])g.fromJson(response, GLEntry[].class);
                    ObservableList myEntries = FXCollections.observableArrayList((Object[])response2);
                    ShowGLEntries.this.allEntries.getItems().removeAll((Collection)ShowGLEntries.this.allEntries.getItems());
                    ShowGLEntries.this.allEntries.setItems(myEntries);
                    Platform.runLater(() -> ShowGLEntries.this.masker.setVisible(false));
                }
                catch (Exception ty) {
                    ty.printStackTrace();
                }
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
    }

    public void setStartDate(LocalDate myStart) {
    }

    public void setEndDate(LocalDate myEnd) {
    }
}

