/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.ShopItem;
import classes.ShopLocation;
import classes.StockConversion;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class StockConversionController
implements Initializable {
    private User user;
    ObservableList<ShopItem> allItems = null;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private Label code;
    @FXML
    private DatePicker conversionDate;
    @FXML
    private ComboBox<ShopLocation> sourceWarehouse;
    @FXML
    private ComboBox<ShopLocation> destinationWarehouse;
    @FXML
    private ComboBox<ShopItem> sourceProduct;
    @FXML
    private Button searchProduct;
    @FXML
    private ComboBox<ShopItem> convertedProduct;
    @FXML
    private TextField quantity;
    @FXML
    private TextField productValue;
    @FXML
    private Button cancel;
    @FXML
    private Button save;
    @FXML
    private Button post;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setStockConversion(StockConversion stockConversion) {
        this.code.setText(stockConversion.getCode());
        this.sourceWarehouse.setValue((Object)stockConversion.getSourceWarehouse());
        this.destinationWarehouse.setValue((Object)stockConversion.getDestinationWarehouse());
        this.sourceProduct.setValue((Object)stockConversion.getSourceProduct());
        this.convertedProduct.setValue((Object)stockConversion.getConvertedProduct());
        this.quantity.setText(stockConversion.getQuantity() + "");
        this.productValue.setText(stockConversion.getValue() + "");
        if (stockConversion.isPosted()) {
            this.post.setDisable(true);
            this.save.setDisable(true);
            this.searchProduct.setDisable(true);
            this.conversionDate.setDisable(true);
            this.quantity.setEditable(false);
        } else {
            this.loadValues();
        }
    }

    public void loadValues() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    StockConversionController.this.notificationPane.setText("Loading Values. Please wait");
                    StockConversionController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    StockConversionController.this.notificationPane.show();
                });
                ObservableList allWarehouses = FXCollections.observableArrayList((Collection)new ShopLocation().getAllLocations(StockConversionController.this.getUser()).stream().filter(v -> !v.isVsm()).collect(Collectors.toList()));
                StockConversionController.this.allItems = new ShopItem().getAllItems(StockConversionController.this.getUser());
                Platform.runLater(() -> {
                    StockConversionController.this.sourceWarehouse.setItems(allWarehouses);
                    StockConversionController.this.destinationWarehouse.setItems(allWarehouses);
                    StockConversionController.this.notificationPane.hide();
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.conversionDate, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.sourceWarehouse, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.destinationWarehouse, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.sourceProduct, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.convertedProduct, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.quantity, Validator.createEmptyValidator((String)"Required"));
        this.cancel.setOnAction(e -> ((Stage)this.cancel.getScene().getWindow()).close());
        this.conversionDate.setValue((Object)Config.getCurrentLocaldate());
        this.sourceWarehouse.setOnAction(e -> {
            ObservableList freeProducts = FXCollections.observableArrayList((Collection)this.allItems.stream().filter(v -> v.getPrice() == 0.0).collect(Collectors.toList()));
            ObservableList nonFreeProducts = FXCollections.observableArrayList((Collection)this.allItems.stream().filter(v -> v.getPrice() != 0.0).collect(Collectors.toList()));
            int warehouseCode = ((ShopLocation)this.sourceWarehouse.getValue()).getId();
            if (warehouseCode == 0) {
                this.sourceProduct.setItems(freeProducts);
                this.convertedProduct.setItems(nonFreeProducts);
            } else {
                this.sourceProduct.setItems(nonFreeProducts);
                this.convertedProduct.setItems(freeProducts);
            }
            this.computeValue();
        });
        this.searchProduct.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("shopitem", gson.toJson((Object)this.sourceProduct.getItems()), this.getUser());
                this.sourceProduct.setValue(gson.fromJson(response, ShopItem.class));
                this.computeValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.save.setOnAction(e -> this.save());
        this.post.setOnAction(e -> {
            if (this.save()) {
                this.post();
            }
        });
        this.sourceProduct.setOnAction(e -> {
            int warehouseCode = ((ShopLocation)this.sourceWarehouse.getValue()).getId();
            String selectedProductCode = ((ShopItem)this.sourceProduct.getValue()).getCode();
            String convertedCode = warehouseCode == 0 ? (selectedProductCode.equalsIgnoreCase("F616838") ? "696894" : (selectedProductCode.equalsIgnoreCase("F661314") ? "730510" : selectedProductCode.substring(1))) : (selectedProductCode.equalsIgnoreCase("696894") ? "F616838" : (selectedProductCode.equalsIgnoreCase("730510") ? "F661314" : "F" + selectedProductCode));
            String finalConvertedCode = convertedCode;
            ObservableList myConvertedProduct = FXCollections.observableArrayList((Collection)this.allItems.stream().filter(v -> v.getCode().equalsIgnoreCase(finalConvertedCode)).collect(Collectors.toList()));
            if (myConvertedProduct.size() > 0) {
                this.convertedProduct.setValue(myConvertedProduct.get(0));
            }
            this.computeValue();
        });
        this.quantity.textProperty().addListener((observable, oldValue, newValue) -> this.computeValue());
    }

    private void computeValue() {
        try {
            double mQuantity = Double.parseDouble(this.quantity.getText().trim());
            int warehouseCode = ((ShopLocation)this.sourceWarehouse.getValue()).getId();
            double tValue = warehouseCode == 0 ? mQuantity * ((ShopItem)this.convertedProduct.getValue()).getBuyingPrice() : mQuantity * ((ShopItem)this.sourceProduct.getValue()).getBuyingPrice() * -1.0;
            this.productValue.setText(Config.formatNumber(tValue));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean save() {
        String tCode;
        int tSourceWarehouse = 0;
        int tDestinationWarehouse = 0;
        String tSourceProduct = "";
        String tConvertedProduct = "";
        String tConversionDate = "";
        double tQuantity = 0.0;
        double tValue = 0.0;
        boolean error = false;
        String message = "";
        try {
            tCode = this.code.getText().trim();
        }
        catch (Exception ignored) {
            tCode = "";
        }
        try {
            tSourceWarehouse = ((ShopLocation)this.sourceWarehouse.getValue()).getId();
        }
        catch (Exception ignored) {
            error = true;
            message = "Please select the source warehouse";
        }
        try {
            tConversionDate = Config.localDateToString((LocalDate)this.conversionDate.getValue());
        }
        catch (Exception ignored) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the conversion date";
        }
        try {
            tDestinationWarehouse = ((ShopLocation)this.destinationWarehouse.getValue()).getId();
        }
        catch (Exception ignored) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the destination warehouse";
        }
        try {
            tSourceProduct = ((ShopItem)this.sourceProduct.getValue()).getCode();
        }
        catch (Exception ignored) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the source product";
        }
        try {
            tConvertedProduct = ((ShopItem)this.convertedProduct.getValue()).getCode();
        }
        catch (Exception ignored) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the converted product";
        }
        try {
            tQuantity = Double.parseDouble(this.quantity.getText().trim());
            if (tQuantity <= 0.0) {
                throw new Exception();
            }
        }
        catch (Exception ignored) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid quantity";
        }
        try {
            tValue = Double.parseDouble(this.productValue.getText().trim().replace(",", ""));
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (!error) {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("code", tCode);
            params.put("conversionDate", tConversionDate);
            params.put("sourceWarehouse", tSourceWarehouse);
            params.put("destinationWarehouse", tDestinationWarehouse);
            params.put("sourceProduct", tSourceProduct);
            params.put("convertedProduct", tConvertedProduct);
            params.put("quantity", tQuantity);
            params.put("value", tValue);
            String response = Config.loadDataFromPhp("mastercreate?type=stock_conversion", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            if (jr.isStatus()) {
                this.code.setText(jr.getOverLoad1());
            }
            return jr.isStatus();
        }
        this.notificationPane.setText(message);
        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
        this.notificationPane.show();
        return false;
    }

    public void post() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("code", this.code.getText().trim());
        String response = Config.loadDataFromPhp("masterpost?type=stock_conversion", params, this.getUser());
        System.out.println(response);
        JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
        if (jr.isStatus()) {
            GeneralListController.publicNotificationPane.setText(jr.getMessage());
            GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
            GeneralListController.publicNotificationPane.show();
            ((Stage)this.post.getScene().getWindow()).close();
        } else {
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
        }
    }
}

