/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.Customer;
import classes.CustomerReceipt;
import classes.CustomerReceiptLines;
import classes.Floor;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.PaymentMethod;
import classes.Property;
import classes.SalesHeader;
import classes.SalesLines;
import classes.Units;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;

public class TenantReceiptController
implements Initializable {
    private User user;
    CustomerReceipt receipt;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private Label receiptNumber;
    @FXML
    private DatePicker paymentDate;
    @FXML
    private ComboBox<Customer> myCustomer;
    @FXML
    private Button chooseCustomer;
    @FXML
    private ComboBox<PaymentMethod> paymentMethod;
    @FXML
    private ComboBox<Bank> bank;
    @FXML
    private CheckBox paidToLandlordsAccount;
    @FXML
    private TextField externalRefNo;
    @FXML
    private Hyperlink totalAmount;
    @FXML
    private ComboBox<SalesHeader> invoice;
    @FXML
    private ComboBox<SalesLines> invoiceLine;
    @FXML
    private TextField description;
    @FXML
    private TextField amount;
    @FXML
    private Button addLine;
    @FXML
    private TableView<CustomerReceiptLines> allLines;
    @FXML
    private TableColumn colInvoice;
    @FXML
    private TableColumn lineNo;
    @FXML
    private TableColumn colDescription;
    @FXML
    private TableColumn colTotalAmount;
    @FXML
    private JFXButton deleteReceipt;
    @FXML
    private JFXButton save;
    @FXML
    private JFXButton postReceipt;
    @FXML
    private JFXButton postAndNew;
    @FXML
    private ComboBox<Property> property;
    @FXML
    private ComboBox<Floor> floor;
    @FXML
    private ComboBox<Units> unit;

    public User getUser() {
        return this.user;
    }

    public void setUser(final User user) {
        this.user = user;
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    TenantReceiptController.this.notificationPane.setText("Loading Values. Please wait");
                    TenantReceiptController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    TenantReceiptController.this.notificationPane.show();
                });
                ObservableList<Property> allProperties = new Property().getAllProperties(user);
                allProperties.sort(Comparator.comparing(Property::getName));
                TenantReceiptController.this.property.setItems(allProperties);
                TenantReceiptController.this.paymentMethod.setItems(new PaymentMethod().getAllPaymentMethods(user));
                TenantReceiptController.this.bank.setItems(Bank.getAllBanks(user));
                Platform.runLater(() -> TenantReceiptController.this.notificationPane.hide());
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public CustomerReceipt getReceipt() {
        return this.receipt;
    }

    public void setReceipt(CustomerReceipt receipt) {
        this.receipt = receipt;
        try {
            this.receiptNumber.setText(receipt.getReceiptNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.myCustomer.setValue((Object)receipt.getCustomer());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bank.setValue((Object)receipt.getBank());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.paymentMethod.setValue((Object)receipt.getPaymentMethod());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.externalRefNo.setText(receipt.getExternalRef());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            LocalDate localDate = LocalDate.parse(receipt.getPaymentDate());
            this.paymentDate.setValue((Object)localDate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.amount.setText(receipt.getAmount() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.property.setValue((Object)receipt.getProperty());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.floor.setValue((Object)receipt.getFloor());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.unit.setValue((Object)receipt.getUnits());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (receipt.isPosted()) {
            this.addLine.setDisable(true);
            this.deleteReceipt.setDisable(true);
            this.postReceipt.setDisable(true);
            this.save.setDisable(true);
            this.postAndNew.setDisable(true);
        }
        this.loadReceiptLines();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.chooseCustomer.setVisible(true);
        this.colInvoice.setCellValueFactory((Callback)new PropertyValueFactory("invoiceNo"));
        this.colDescription.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        this.colTotalAmount.setCellValueFactory((Callback)new PropertyValueFactory("totalAmountString"));
        this.lineNo.setCellValueFactory((Callback)new PropertyValueFactory("invoiceLineNo"));
        this.property.setOnAction(e -> {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    Platform.runLater(() -> {
                        TenantReceiptController.this.notificationPane.setText("Loading Values. Please wait");
                        TenantReceiptController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                        TenantReceiptController.this.notificationPane.show();
                    });
                    ObservableList<Floor> allFloors = new Floor().getAllFloors(((Property)TenantReceiptController.this.property.getValue()).getPropertyCode(), TenantReceiptController.this.getUser());
                    ObservableList<Units> allUnits = new Units().getAllUnits(((Property)TenantReceiptController.this.property.getValue()).getPropertyCode(), TenantReceiptController.this.getUser());
                    Platform.runLater(() -> {
                        TenantReceiptController.this.floor.setItems(allFloors);
                        TenantReceiptController.this.unit.setItems(allUnits);
                        TenantReceiptController.this.notificationPane.hide();
                    });
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
        });
        this.floor.setOnAction(e -> {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    Platform.runLater(() -> {
                        TenantReceiptController.this.notificationPane.setText("Loading Values. Please wait");
                        TenantReceiptController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                        TenantReceiptController.this.notificationPane.show();
                    });
                    ObservableList<Units> floorUnits = new Units().getFloorUnits(((Property)TenantReceiptController.this.property.getValue()).getPropertyCode(), ((Floor)TenantReceiptController.this.floor.getValue()).getFloorId() + "", TenantReceiptController.this.getUser());
                    Platform.runLater(() -> {
                        TenantReceiptController.this.unit.setItems(floorUnits);
                        TenantReceiptController.this.notificationPane.hide();
                    });
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
        });
        this.unit.setOnAction(e -> this.loadCustomers());
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.paymentDate.setValue((Object)Config.getCurrentLocaldate());
        this.paidToLandlordsAccount.setOnAction(e -> {
            if (this.paidToLandlordsAccount.isSelected()) {
                this.bank.setValue(null);
                this.bank.setDisable(true);
            } else {
                this.bank.setDisable(false);
            }
        });
        this.myCustomer.setOnAction(t -> {
            Customer tenant = (Customer)this.myCustomer.getValue();
            this.invoice.setItems(new SalesHeader().getCustomerPendingInvoices(true, this.getUser(), tenant.getCustomerNumber(), "tenantInvoice"));
        });
        this.invoice.setOnAction(e -> {
            SalesHeader selectedInvoice = (SalesHeader)this.invoice.getValue();
            this.invoiceLine.setItems(new SalesLines().getAllLines(selectedInvoice.getDoc_no(), selectedInvoice.getDocType(), this.getUser()));
        });
        this.invoiceLine.setOnAction(e -> this.description.setText(((SalesLines)this.invoiceLine.getValue()).getDescription()));
        this.addLine.setOnAction(e -> {
            if (this.save()) {
                int tLineId = 0;
                String tInvoiceNo = "";
                String tDescription = "";
                double tAmount = 0.0;
                String message = "";
                boolean error = false;
                try {
                    tLineId = ((SalesLines)this.invoiceLine.getValue()).getLineId();
                    if (tLineId < 1) {
                        throw new Exception();
                    }
                }
                catch (Exception u) {
                    error = true;
                    message = "Please select the invoice line";
                }
                try {
                    tInvoiceNo = ((SalesHeader)this.invoice.getValue()).getDoc_no().trim();
                }
                catch (Exception u) {
                    tInvoiceNo = "";
                }
                try {
                    tDescription = this.description.getText().trim();
                    if (tDescription.length() < 4) {
                        throw new Exception();
                    }
                }
                catch (Exception y) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter a valid transaction description, atleast 4 characters";
                }
                try {
                    tAmount = Double.parseDouble(this.amount.getText().trim());
                }
                catch (Exception y) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter a valid amount";
                }
                if (error) {
                    this.notificationPane.setText(message);
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                } else {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("receiptNo", this.receiptNumber.getText().trim());
                    params.put("paymentType", 0);
                    params.put("lineId", tLineId);
                    params.put("invoiceNo", tInvoiceNo);
                    params.put("description", tDescription);
                    params.put("amount", tAmount);
                    String response = Config.loadDataFromPhp("mastercreate?type=customerreceiptline", params, this.getUser());
                    System.out.println(response);
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                    if (jr.isStatus()) {
                        this.loadReceiptLines();
                    }
                }
            }
        });
        this.chooseCustomer.setOnAction(t -> {
            try {
                String response = new Config().getObjectFromSelection("tenant", this.getUser());
                Customer tenant = (Customer)new Gson().fromJson(response, Customer.class);
                tenant.getCustomerNumber();
                this.myCustomer.setValue((Object)tenant);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.postReceipt.setOnAction(t -> {
            if (this.save()) {
                JsonResponses jr = new CustomerReceipt().postReceipt(this.receiptNumber.getText().trim(), this.getUser());
                if (jr.isStatus()) {
                    GeneralListController.publicNotificationPane.setText(jr.getMessage());
                    GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                    GeneralListController.publicNotificationPane.show();
                    Stage stage = (Stage)this.postReceipt.getScene().getWindow();
                    stage.close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
        });
        this.postAndNew.setOnAction(t -> {
            if (this.save()) {
                JsonResponses jr = new CustomerReceipt().postReceipt(this.receiptNumber.getText().trim(), this.getUser());
                if (jr.isStatus()) {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                    this.receiptNumber.setText("");
                    this.unit.setValue(null);
                    this.floor.setValue(null);
                    this.myCustomer.setValue(null);
                    this.invoice.setItems(null);
                    this.invoiceLine.setItems(null);
                    this.allLines.setItems(null);
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
        });
        this.save.setOnAction(e -> this.save());
    }

    public boolean save() {
        String tReceiptNo = "";
        NumberSeries nb = new NumberSeries(8, this.getUser());
        try {
            tReceiptNo = this.receiptNumber.getText().trim();
        }
        catch (Exception e) {
            tReceiptNo = "";
        }
        boolean newReceipt = false;
        if (tReceiptNo.equals("")) {
            tReceiptNo = nb.getNextNumber();
            newReceipt = true;
        }
        String tCustomer = "";
        try {
            tCustomer = ((Customer)this.myCustomer.getValue()).getCustomerNumber();
            if (tCustomer.equals(null) || tCustomer.trim().equals("")) {
                tCustomer = "";
            }
        }
        catch (Exception p) {
            tCustomer = "";
        }
        int tBank = 0;
        try {
            tBank = ((Bank)this.bank.getValue()).getCode();
        }
        catch (Exception e) {
            tBank = 0;
        }
        int tPaymentMethod = 0;
        try {
            tPaymentMethod = ((PaymentMethod)this.paymentMethod.getValue()).getCode();
        }
        catch (Exception e) {
            tPaymentMethod = 0;
        }
        String tPaymentRef = this.externalRefNo.getText().trim();
        String tPaymentDate = "";
        try {
            tPaymentDate = ((LocalDate)this.paymentDate.getValue()).toString();
        }
        catch (Exception r) {
            tPaymentDate = "";
        }
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("receiptNo", tReceiptNo);
            params.put("customerNo", tCustomer);
            params.put("bankCode", tBank);
            params.put("paymentMethod", tPaymentMethod);
            params.put("paymentRef", tPaymentRef);
            params.put("paymentDate", tPaymentDate);
            params.put("landlordAccount", this.paidToLandlordsAccount.isSelected() ? 1 : 0);
            String response = Config.loadDataFromPhp("mastercreate?type=customerreceipt", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (newReceipt) {
                nb.updateLastUsed(tReceiptNo);
                this.receiptNumber.setText(jr.getOverLoad1());
            }
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            return jr.isStatus();
        }
        catch (Exception e) {
            this.notificationPane.setText("We encountered an error while saving the receipt. Please try again");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
            return false;
        }
    }

    public void loadReceiptLines() {
        ObservableList<CustomerReceiptLines> addedLines = new CustomerReceiptLines().getLines(this.receiptNumber.getText().trim(), this.getUser());
        this.allLines.setItems(addedLines);
        double mTotalAmount = 0.0;
        for (int a = 0; a < addedLines.size(); ++a) {
            mTotalAmount += ((CustomerReceiptLines)addedLines.get(a)).getTotalAmount();
        }
        this.totalAmount.setText(Config.formatNumber(mTotalAmount));
    }

    private void loadCustomers() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    TenantReceiptController.this.notificationPane.setText("Loading Values. Please wait");
                    TenantReceiptController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    TenantReceiptController.this.notificationPane.show();
                });
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("customerType", "tenant");
                params.put("unit", ((Units)TenantReceiptController.this.unit.getValue()).getUnitId());
                ObservableList<Customer> allCustomers = new Customer().getAllCustomers(params, TenantReceiptController.this.getUser());
                Platform.runLater(() -> {
                    TenantReceiptController.this.myCustomer.setItems(allCustomers);
                    TenantReceiptController.this.myCustomer.getSelectionModel().select(0);
                    TenantReceiptController.this.notificationPane.hide();
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }
}

