/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Town;
import classes.User;
import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;

public class TownsController
implements Initializable {
    @FXML
    private TableView<Town> allTowns;
    @FXML
    private TableColumn townId;
    @FXML
    private TableColumn townName;
    @FXML
    private TableColumn townCounty;
    @FXML
    private TableColumn monthlyParkingFeeCounty;
    @FXML
    private TableColumn monthlyParkingFeeSacco;
    @FXML
    private TableColumn edit;
    @FXML
    private TableColumn delete;
    @FXML
    private TextField search;
    @FXML
    private JFXButton addTown;
    @FXML
    private JFXButton clearFilter;

    public void initialize(URL location, ResourceBundle resources) {
        this.townId.setCellValueFactory((Callback)new PropertyValueFactory("townId"));
        this.townName.setCellValueFactory((Callback)new PropertyValueFactory("townName"));
        this.townCounty.setCellValueFactory((Callback)new PropertyValueFactory("county"));
        this.monthlyParkingFeeCounty.setCellValueFactory((Callback)new PropertyValueFactory("countyFeeString"));
        this.monthlyParkingFeeSacco.setCellValueFactory((Callback)new PropertyValueFactory("saccoFeeString"));
        this.addTown.setOnAction(e -> {
            Parent root = null;
            try {
                root = (Parent)FXMLLoader.load((URL)this.getClass().getResource("/fxml/addtown.fxml"));
                Scene scene = new Scene(root, 522.0, 253.0);
                final Stage stage = new Stage();
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(scene);
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setTitle("Add Town");
                stage.show();
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                TownsController.this.loadTowns();
                            }
                        });
                    }
                });
            }
            catch (Exception j) {
                j.printStackTrace();
            }
        });
        this.loadTowns();
    }

    public void loadTowns() {
        this.allTowns.setItems(new Town().getAllTowns(new User()));
    }
}

