/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.Member;
import classes.NumberSeries;
import classes.TransferVehicle;
import classes.User;
import classes.Vehicle;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class TransferVehicleController
implements Initializable {
    private User user;
    private TransferVehicle transferVehicle;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox notificationHolder;
    @FXML
    private Label transferNo;
    @FXML
    private DatePicker transferDate;
    @FXML
    private ComboBox<Member> previousOwner;
    @FXML
    private Button choosePreviousOwner;
    @FXML
    private ComboBox<Vehicle> vehicle;
    @FXML
    private Label serviceArrears;
    @FXML
    private ComboBox<Member> newOwner;
    @FXML
    private Button chooseNewOwner;
    @FXML
    private Button cancel;
    @FXML
    private Button save;
    @FXML
    private Button post;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public TransferVehicle getTransferVehicle() {
        return this.transferVehicle;
    }

    public void setTransferVehicle(TransferVehicle transferVehicle) {
        this.transferVehicle = transferVehicle;
        try {
            this.transferNo.setText(transferVehicle.getTransferNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.transferDate.setValue((Object)Config.stringToLocalDate(transferVehicle.getTransferDate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.previousOwner.setValue((Object)transferVehicle.getPreviousOwner());
            try {
                String memberNo = ((Member)this.previousOwner.getValue()).getMemberNumber();
                ObservableList<Vehicle> allVehicles = new Vehicle().getMemberVehicles(memberNo, this.getUser());
                this.vehicle.setItems(allVehicles);
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.vehicle.setValue((Object)transferVehicle.getVehicle());
            this.getBalance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.newOwner.setValue((Object)transferVehicle.getNewOwner());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (transferVehicle.isPosted()) {
            this.save.setDisable(true);
            this.post.setDisable(true);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.transferDate.setValue((Object)Config.getCurrentLocaldate());
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    TransferVehicleController.this.notificationPane.setText("Loading values. Please wait....");
                    TransferVehicleController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    TransferVehicleController.this.notificationPane.show();
                });
                ObservableList<Member> allMembers = new Member().getAllMembers(TransferVehicleController.this.getUser());
                TransferVehicleController.this.previousOwner.setItems(allMembers);
                TransferVehicleController.this.newOwner.setItems(allMembers);
                Platform.runLater(() -> TransferVehicleController.this.notificationPane.hide());
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
        this.previousOwner.setOnAction(e -> {
            try {
                String memberNo = ((Member)this.previousOwner.getValue()).getMemberNumber();
                ObservableList<Vehicle> allVehicles = new Vehicle().getMemberVehicles(memberNo, this.getUser());
                this.vehicle.setItems(allVehicles);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.vehicle.setOnAction(e -> this.getBalance());
        this.save.setOnAction(e -> this.save());
        this.post.setOnAction(e -> {
            if (this.post()) {
                GeneralListController.publicNotificationPane.setText(this.notificationPane.getText());
                GeneralListController.publicNotificationPane.setGraphic(this.notificationPane.getGraphic());
                GeneralListController.publicNotificationPane.show();
                Stage stage = (Stage)this.post.getScene().getWindow();
                stage.close();
            }
        });
        this.notificationPane.setContent((Node)this.notificationHolder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.previousOwner, Validator.createEmptyValidator((String)"Previous Owner is required"));
        vs.registerValidator(this.newOwner, Validator.createEmptyValidator((String)"New Owner is required"));
        vs.registerValidator(this.vehicle, Validator.createEmptyValidator((String)"Vehicle is required"));
        vs.registerValidator((Control)this.transferDate, Validator.createEmptyValidator((String)"Transfer Date is required"));
        this.choosePreviousOwner.setOnAction(e -> {
            try {
                Member m = new Member().getMemberFromSelection(this.getUser());
                String mNo = m.getMemberNumber();
                if (!mNo.equals("") && !mNo.equals(null)) {
                    this.previousOwner.setValue((Object)m);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.chooseNewOwner.setOnAction(e -> {
            try {
                Member m = new Member().getMemberFromSelection(this.getUser());
                String mNo = m.getMemberNumber();
                if (!mNo.equals("") && !mNo.equals(null)) {
                    this.newOwner.setValue((Object)m);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
    }

    public void getBalance() {
        String vehicleNo = "";
        try {
            vehicleNo = ((Vehicle)this.vehicle.getValue()).getRegNo();
        }
        catch (Exception t) {
            vehicleNo = "";
        }
        if (!vehicleNo.equals(null) && !vehicleNo.equals("")) {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("vehicleNo", vehicleNo);
                String response = Config.loadDataFromPhp("masterfetch?type=vehiclearrearsbalance", params, this.getUser());
                Double[] myValues = (Double[])new Gson().fromJson(response, Double[].class);
                this.serviceArrears.setText(Config.formatNumber(myValues[0]));
            }
            catch (NullPointerException params) {
            }
            catch (Exception t) {
                this.notificationPane.setText("We could not be able to compute the vehicle arrears");
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        }
    }

    public boolean save() {
        String tTransferNo = "";
        String tTransferDate = "";
        String tPreviousOwner = "";
        String tNewOwner = "";
        String tVehicleReg = "";
        boolean error = false;
        boolean newVoucher = false;
        String message = "";
        NumberSeries ns = new NumberSeries(17, this.getUser());
        try {
            tTransferNo = this.transferNo.getText().trim();
            if (tTransferNo.equals(null) || tTransferNo.equals("") || tTransferNo.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            tTransferNo = ns.getNextNumber();
            newVoucher = true;
        }
        try {
            tTransferDate = Config.localDateToString((LocalDate)this.transferDate.getValue());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select a valid date";
        }
        try {
            tPreviousOwner = ((Member)this.previousOwner.getValue()).getMemberNumber();
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the previous owner of the vehicle";
        }
        try {
            tVehicleReg = ((Vehicle)this.vehicle.getValue()).getRegNo();
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the vehicle to transfer";
        }
        try {
            tNewOwner = ((Member)this.newOwner.getValue()).getMemberNumber();
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the new owner of the vehicle";
        }
        if (!error) {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("transferNo", tTransferNo);
                params.put("transferDate", tTransferDate);
                params.put("previousOwner", tPreviousOwner);
                params.put("vehicleReg", tVehicleReg);
                params.put("newOwner", tNewOwner);
                String response = Config.loadDataFromPhp("mastercreate?type=transfervehicle", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus()) {
                    if (newVoucher) {
                        this.transferNo.setText(tTransferNo);
                        ns.updateLastUsed(tTransferNo);
                    }
                    return true;
                }
            }
            catch (Exception t) {
                this.notificationPane.setText("We experienced an error while processing your request");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        } else {
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        }
        return false;
    }

    public boolean post() {
        if (this.save()) {
            try {
                String tTransferNo = this.transferNo.getText().trim();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("transferNo", tTransferNo);
                String response = Config.loadDataFromPhp("masterpost?type=transfervehicle", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                return jr.isStatus();
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while processing your request.");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }
}

