/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.UnitTypes;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.controlsfx.control.NotificationPane;

public class UnitTypesController
implements Initializable {
    private User user;
    @FXML
    private VBox vbAddProperty;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox vbHolder;
    @FXML
    private Label unitTypeId;
    @FXML
    private TextField unitType;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnCancel;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        Platform.runLater(() -> {
            this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.vbHolder);
        });
        this.btnCancel.setOnAction(event -> this.cancel());
        this.btnSave.setOnAction(event -> this.save());
    }

    private void save() {
        try {
            String id = this.unitTypeId.getText().trim();
            String name = this.unitType.getText().trim();
            if (name.equals("") || name.length() == 0) {
                this.notificationPane.setText("Enter a valid name");
                this.notificationPane.show();
                return;
            }
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            if (id.length() == 0) {
                id = "0";
            }
            params.put("id", id);
            params.put("name", name);
            String response = Config.loadDataFromPhp("mastercreate?type=unittype", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.show();
            if (jr.isStatus()) {
                this.cancel();
            }
        }
        catch (Exception t) {
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.setText("We encountered an error while processing your request");
            this.notificationPane.show();
        }
    }

    private void cancel() {
        Stage stage = (Stage)this.vbAddProperty.getScene().getWindow();
        stage.fireEvent(new Event(WindowEvent.WINDOW_CLOSE_REQUEST));
    }

    public void setUnitType(UnitTypes unitTypes) {
        this.unitTypeId.setText(unitTypes.getId() + "");
        this.unitType.setText(unitTypes.getName());
    }
}

