/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Floor;
import classes.JsonResponses;
import classes.Property;
import classes.UnitTypes;
import classes.Units;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class UnitsController
implements Initializable {
    private User user;
    private Property myProperty;
    @FXML
    private JFXButton clearFilter;
    @FXML
    private ComboBox<Property> property;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private StackPane holder;
    @FXML
    private TableView<Units> allUnits;
    @FXML
    private TableColumn colUnitCode;
    @FXML
    private TableColumn colFloor;
    @FXML
    private TableColumn colUnitType;
    @FXML
    private TableColumn colMonthlyRent;
    @FXML
    private TableColumn colSize;
    @FXML
    private TableColumn colStatus;
    @FXML
    private TableColumn colMonthlyCharges;
    @FXML
    private TableColumn colEdit;
    @FXML
    private TableColumn colDelete;
    @FXML
    private MaskerPane masker;
    @FXML
    private TextField unitCode;
    @FXML
    private ComboBox<Floor> floor;
    @FXML
    private ComboBox<UnitTypes> unitType;
    @FXML
    private TextField monthlyRent;
    @FXML
    private TextField searchBar;
    @FXML
    private TextField size;
    @FXML
    private Button addUnit;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        ObservableList<Property> allProperties = new Property().getAllProperties(user);
        allProperties.sort(Comparator.comparing(Property::getName));
        this.property.setItems(allProperties);
        new UnitTypes();
        ObservableList<UnitTypes> allTypes = UnitTypes.getAllUnitType(user);
        allTypes.sort(Comparator.comparing(UnitTypes::getName));
        this.unitType.setItems(allTypes);
    }

    public Property getMyProperty() {
        return this.myProperty;
    }

    public void setMyProperty(Property myProperty) {
        this.myProperty = myProperty;
        this.property.setValue((Object)myProperty);
        this.loadFloors();
        this.loadUnits();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.property.setOnAction(e -> {
            this.loadFloors();
            this.loadUnits();
        });
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.unitCode, Validator.createEmptyValidator((String)"Required"));
        this.colUnitCode.setCellValueFactory((Callback)new PropertyValueFactory("unitCode"));
        this.colFloor.setCellValueFactory((Callback)new PropertyValueFactory("floor"));
        this.colUnitType.setCellValueFactory((Callback)new PropertyValueFactory("unitType"));
        this.colMonthlyRent.setCellValueFactory((Callback)new PropertyValueFactory("monthlyRentString"));
        this.colSize.setCellValueFactory((Callback)new PropertyValueFactory("size"));
        this.colStatus.setCellValueFactory((Callback)new PropertyValueFactory("floorNo"));
        this.colMonthlyCharges.setCellValueFactory((Callback)new PropertyValueFactory("floorNo"));
        this.colEdit.setCellValueFactory((Callback)new PropertyValueFactory("floorNo"));
        this.colDelete.setCellValueFactory((Callback)new PropertyValueFactory("floorNo"));
        this.searchBar.textProperty().addListener((observable, oldValue, newValue) -> {
            ObservableList<Units> beforeSearch = new Units().getAllUnits(((Property)this.property.getValue()).getPropertyCode(), this.getUser());
            ObservableList afterSearch = FXCollections.observableArrayList();
            for (int b = 0; b < beforeSearch.size(); ++b) {
                try {
                    Units current = (Units)beforeSearch.get(b);
                    String unitcode = "";
                    try {
                        unitcode = current.getUnitCode().toLowerCase();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String floor = "";
                    try {
                        floor = current.getFloor().getFloorName().toLowerCase();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String monthlyrent = "";
                    try {
                        monthlyrent = current.getMonthlyRentString() + "";
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String searched = "";
                    try {
                        searched = newValue.toLowerCase();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!unitcode.contains(searched) && !floor.contains(searched) && !monthlyrent.contains(searched)) continue;
                    afterSearch.add((Object)current);
                    continue;
                }
                catch (Exception y) {
                    y.printStackTrace();
                }
            }
            this.allUnits.getItems().removeAll(beforeSearch);
            this.allUnits.setItems(afterSearch);
        });
        this.clearFilter.setOnAction(e -> this.searchBar.setText(""));
        this.addUnit.setOnAction(e -> {
            try {
                String tUnitCode = "";
                int tFloorNo = 0;
                int tUnitType = 0;
                double tMonthlyRent = 0.0;
                String tSize = this.size.getText().trim();
                boolean error = false;
                String message = "";
                tUnitCode = this.unitCode.getText().trim();
                try {
                    tFloorNo = ((Floor)this.floor.getValue()).getFloorId();
                }
                catch (Exception y) {
                    tFloorNo = 0;
                }
                try {
                    tUnitType = ((UnitTypes)this.unitType.getValue()).getId();
                }
                catch (Exception y) {
                    tUnitType = 0;
                }
                if (tUnitCode.length() < 1) {
                    error = false;
                    message = "Please enter the unit code";
                }
                try {
                    tMonthlyRent = Double.parseDouble(this.monthlyRent.getText().trim());
                }
                catch (Exception y) {
                    tMonthlyRent = 0.0;
                }
                if (error) {
                    this.notificationPane.setText(message);
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                } else {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("unitCode", tUnitCode);
                    params.put("floorNo", tFloorNo);
                    params.put("unitType", tUnitType);
                    params.put("size", tSize);
                    params.put("monthlyRent", tMonthlyRent);
                    params.put("size", tSize);
                    params.put("propertyCode", ((Property)this.property.getValue()).getPropertyCode());
                    String response = Config.loadDataFromPhp("mastercreate?type=unit", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                    if (jr.isStatus()) {
                        this.loadUnits();
                        this.clearFields();
                    }
                }
            }
            catch (Exception y) {
                this.notificationPane.setText("We encountered an error while processing your request");
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        });
    }

    public void loadFloors() {
        try {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    Platform.runLater(() -> UnitsController.this.floor.setItems(new Floor().getAllFloors(((Property)UnitsController.this.property.getValue()).getPropertyCode(), UnitsController.this.getUser())));
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
        }
        catch (Exception y) {
            this.notificationPane.setText("We experienced an error while loading the data");
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        }
    }

    public void loadUnits() {
        try {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    Platform.runLater(() -> UnitsController.this.masker.setVisible(true));
                    UnitsController.this.allUnits.setItems(new Units().getAllUnits(((Property)UnitsController.this.property.getValue()).getPropertyCode(), UnitsController.this.getUser()));
                    Platform.runLater(() -> UnitsController.this.masker.setVisible(false));
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
        }
        catch (Exception y) {
            this.notificationPane.setText("We experienced an error while loading the data");
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        }
    }

    public void clearFields() {
        this.unitCode.setText("");
        this.monthlyRent.setText("");
        this.size.setText("");
        this.floor.getSelectionModel().select(0);
        this.unitType.getSelectionModel().select(0);
    }
}

