/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.User;
import classes.VehicleBrands;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class VehicleBrandsController
implements Initializable {
    private User user;
    private VehicleBrands vehicleBrands;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox notificationHolder;
    @FXML
    private Label brandId;
    @FXML
    private TextField brandName;
    @FXML
    private TextField monthlyServiceFee;
    @FXML
    private TextField dailyServiceFee;
    @FXML
    private Button cancel;
    @FXML
    private Button save;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public VehicleBrands getVehicleBrands() {
        return this.vehicleBrands;
    }

    public void setVehicleBrands(VehicleBrands vehicleBrands) {
        this.vehicleBrands = vehicleBrands;
        try {
            this.brandId.setText(vehicleBrands.getBrandId() + "");
            this.brandName.setText(vehicleBrands.getBrandName());
            this.monthlyServiceFee.setText(vehicleBrands.getMonthlyServiceFee() + "");
            this.dailyServiceFee.setText(vehicleBrands.getDailyServiceFee() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.notificationHolder);
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.brandName, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.monthlyServiceFee, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.dailyServiceFee, Validator.createEmptyValidator((String)"Required"));
        this.monthlyServiceFee = new Config().setDoubleTextField(this.monthlyServiceFee);
        this.dailyServiceFee = new Config().setDoubleTextField(this.dailyServiceFee);
        this.save.setOnAction(e -> {
            String tBrandId = this.brandId.getText().trim();
            int myBrandId = 0;
            if (tBrandId.length() > 0) {
                try {
                    myBrandId = Integer.parseInt(tBrandId);
                }
                catch (Exception t) {
                    myBrandId = 0;
                }
            }
            String tBrandName = this.brandName.getText().trim();
            String message = "";
            boolean error = false;
            if (tBrandName.length() < 1) {
                error = true;
                message = "Please specify the brand name";
            }
            double mMonthly = 0.0;
            double mDaily = 0.0;
            try {
                mMonthly = Double.parseDouble(this.monthlyServiceFee.getText().trim());
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a valid monthly service fee";
            }
            try {
                mDaily = Double.parseDouble(this.dailyServiceFee.getText().trim());
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a valid daily service fee";
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("brandId", myBrandId);
                params.put("brandName", tBrandName);
                params.put("monthly", mMonthly);
                params.put("daily", mDaily);
                String response = Config.loadDataFromPhp("mastercreate?type=vehiclebrand", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    GeneralListController.publicNotificationPane.setText(jr.getMessage());
                    GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                    GeneralListController.publicNotificationPane.show();
                    Stage stage = (Stage)this.save.getScene().getWindow();
                    stage.close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
        });
    }
}

