/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.JsonResponses;
import classes.Member;
import classes.NumberSeries;
import classes.User;
import classes.Vehicle;
import classes.VehicleExit;
import classes.VehicleFees;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class VehicleExitController
implements Initializable {
    private User user;
    private VehicleExit vehicleExit;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox notificationHolder;
    @FXML
    private Label exitNo;
    @FXML
    private DatePicker exitDate;
    @FXML
    private ComboBox<Member> owner;
    @FXML
    private Button chooseOwner;
    @FXML
    private ComboBox<Vehicle> vehicle;
    @FXML
    private Label serviceFeeArrears;
    @FXML
    private TextField noObjectionFee;
    @FXML
    private ComboBox<Bank> bank;
    @FXML
    private Button cancel;
    @FXML
    private Button save;
    @FXML
    private Button post;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public VehicleExit getVehicleExit() {
        return this.vehicleExit;
    }

    public void setVehicleExit(VehicleExit vehicleExit) {
        this.vehicleExit = vehicleExit;
        try {
            this.exitNo.setText(vehicleExit.getExitNumber());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.exitDate.setValue((Object)Config.stringToLocalDate(vehicleExit.getExitDate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.owner.setValue((Object)vehicleExit.getOwner());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bank.setValue((Object)vehicleExit.getReceivingBank());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.vehicle.setValue((Object)vehicleExit.getVehicle());
            this.getBalance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.noObjectionFee.setText(vehicleExit.getNoObjectionFee() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (vehicleExit.isPosted()) {
            this.save.setDisable(true);
            this.post.setDisable(true);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.exitDate.setValue((Object)Config.getCurrentLocaldate());
        ObservableList<VehicleFees> fees = new VehicleFees().getAllStandardFees(this.getUser());
        for (VehicleFees fee : fees) {
            if (fee.getCode() != 4) continue;
            this.noObjectionFee.setText(fee.getAmount() + "");
        }
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    VehicleExitController.this.notificationPane.setText("Loading values. Please wait....");
                    VehicleExitController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    VehicleExitController.this.notificationPane.show();
                });
                ObservableList<Member> allMembers = new Member().getAllMembers(VehicleExitController.this.getUser());
                VehicleExitController.this.owner.setItems(allMembers);
                ObservableList<Bank> allBanks = Bank.getAllBanks(VehicleExitController.this.getUser());
                VehicleExitController.this.bank.setItems(allBanks);
                Platform.runLater(() -> VehicleExitController.this.notificationPane.hide());
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
        this.owner.setOnAction(e -> {
            try {
                String memberNo = ((Member)this.owner.getValue()).getMemberNumber();
                ObservableList<Vehicle> allVehicles = new Vehicle().getMemberVehicles(memberNo, this.getUser());
                this.vehicle.setItems(allVehicles);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.vehicle.setOnAction(e -> this.getBalance());
        this.save.setOnAction(e -> this.save());
        this.post.setOnAction(e -> {
            if (this.post()) {
                GeneralListController.publicNotificationPane.setText(this.notificationPane.getText());
                GeneralListController.publicNotificationPane.setGraphic(this.notificationPane.getGraphic());
                GeneralListController.publicNotificationPane.show();
                Stage stage = (Stage)this.post.getScene().getWindow();
                stage.close();
            }
        });
        this.notificationPane.setContent((Node)this.notificationHolder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.owner, Validator.createEmptyValidator((String)"Owner is required"));
        vs.registerValidator(this.vehicle, Validator.createEmptyValidator((String)"Vehicle is required"));
        vs.registerValidator((Control)this.exitDate, Validator.createEmptyValidator((String)"Exit Date is required"));
        this.chooseOwner.setOnAction(e -> {
            try {
                Member m = new Member().getMemberFromSelection(this.getUser());
                String mNo = m.getMemberNumber();
                if (!mNo.equals("") && !mNo.equals(null)) {
                    this.owner.setValue((Object)m);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
    }

    public void getBalance() {
        String vehicleNo = "";
        try {
            vehicleNo = ((Vehicle)this.vehicle.getValue()).getRegNo();
        }
        catch (Exception t) {
            vehicleNo = "";
        }
        if (!vehicleNo.equals(null) && !vehicleNo.equals("")) {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("vehicleNo", vehicleNo);
                String response = Config.loadDataFromPhp("masterfetch?type=vehiclearrearsbalance", params, this.getUser());
                Double[] myValues = (Double[])new Gson().fromJson(response, Double[].class);
                this.serviceFeeArrears.setText(Config.formatNumber(myValues[0]));
            }
            catch (NullPointerException params) {
            }
            catch (Exception t) {
                this.notificationPane.setText("We could not be able to compute the vehicle arrears");
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        }
    }

    public boolean save() {
        String tExitNo = "";
        String tExitDate = "";
        String tOwner = "";
        String tVehicleReg = "";
        int tBankCode = 0;
        double tNoObjectionFee = 0.0;
        boolean error = false;
        boolean newVoucher = false;
        String message = "";
        NumberSeries ns = new NumberSeries(18, this.getUser());
        try {
            tExitNo = this.exitNo.getText().trim();
            if (tExitNo.equals(null) || tExitNo.equals("") || tExitNo.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            tExitNo = ns.getNextNumber();
            newVoucher = true;
        }
        try {
            tExitDate = Config.localDateToString((LocalDate)this.exitDate.getValue());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select a valid exit date";
        }
        try {
            tOwner = ((Member)this.owner.getValue()).getMemberNumber();
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the owner of the vehicle";
        }
        try {
            tVehicleReg = ((Vehicle)this.vehicle.getValue()).getRegNo();
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the vehicle exiting the sacco";
        }
        try {
            tBankCode = ((Bank)this.bank.getValue()).getCode();
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the bank receiving the no objection fee";
        }
        try {
            tNoObjectionFee = Double.parseDouble(this.noObjectionFee.getText().trim());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid Amount for no objection fee";
        }
        if (!error) {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("exitNo", tExitNo);
                params.put("exitDate", tExitDate);
                params.put("owner", tOwner);
                params.put("vehicleReg", tVehicleReg);
                params.put("bankCode", tBankCode);
                params.put("noObjectionFee", tNoObjectionFee);
                String response = Config.loadDataFromPhp("mastercreate?type=vehicleexit", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus()) {
                    if (newVoucher) {
                        this.exitNo.setText(tExitNo);
                        ns.updateLastUsed(tExitNo);
                    }
                    return true;
                }
            }
            catch (Exception t) {
                this.notificationPane.setText("We experienced an error while processing your request");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        } else {
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        }
        return false;
    }

    public boolean post() {
        if (this.save()) {
            try {
                String tExitNo = this.exitNo.getText().trim();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("exitNo", tExitNo);
                String response = Config.loadDataFromPhp("masterpost?type=vehicleexit", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                return jr.isStatus();
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while processing your request.");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }
}

