/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.User;
import classes.VehicleFees;
import classes.VehicleMakes;
import classes.VehicleModels;
import com.google.gson.Gson;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import javafx.util.converter.IntegerStringConverter;
import org.controlsfx.control.NotificationPane;

public class VehicleSetupsController
implements Initializable {
    private User user;
    @FXML
    private TableView<VehicleMakes> vehicleMakes;
    @FXML
    private TableColumn colVehicleMake;
    @FXML
    private TableView<VehicleModels> allModels;
    @FXML
    private TableColumn colMake;
    @FXML
    private TableColumn colModel;
    @FXML
    private TableColumn colCapacity;
    @FXML
    private TableColumn dailyFee;
    @FXML
    private TableView<VehicleFees> vehicleFees;
    @FXML
    private TableColumn feeDescription;
    @FXML
    private TableColumn feeAmount;
    @FXML
    AnchorPane holder;
    @FXML
    NotificationPane notificationPane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.loadVehicleMakes();
        this.colVehicleMake.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        this.colVehicleMake.setCellFactory(TextFieldTableCell.forTableColumn());
        this.colVehicleMake.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<VehicleMakes, String>>(){

            public void handle(TableColumn.CellEditEvent<VehicleMakes, String> t) {
                VehicleMakes pl = (VehicleMakes)t.getTableView().getItems().get(t.getTablePosition().getRow());
                try {
                    String vehicleMake = (String)t.getNewValue();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("Description", vehicleMake);
                    params.put("Code", pl.getCode());
                    String response = Config.loadDataFromPhp("mastercreate?type=vehiclemake", params, VehicleSetupsController.this.getUser());
                    System.out.println(response);
                    Gson g = new Gson();
                    JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                    VehicleSetupsController.this.notificationPane.setText(jr.getMessage());
                    VehicleSetupsController.this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    VehicleSetupsController.this.notificationPane.show();
                    VehicleSetupsController.this.loadVehicleMakes();
                }
                catch (Exception r) {
                    VehicleSetupsController.this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                    VehicleSetupsController.this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    VehicleSetupsController.this.notificationPane.show();
                }
            }
        });
        this.colModel.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        this.colModel.setCellFactory(TextFieldTableCell.forTableColumn());
        this.colModel.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<VehicleModels, String>>(){

            public void handle(TableColumn.CellEditEvent<VehicleModels, String> t) {
                VehicleModels pl = (VehicleModels)t.getTableView().getItems().get(t.getTablePosition().getRow());
                String vehicleModel = (String)t.getNewValue();
                VehicleSetupsController.this.updateVehicleModel(pl.getCode(), vehicleModel, pl.getMake().getCode(), pl.getCapacity(), pl.getDailyFee());
            }
        });
        this.colCapacity.setCellValueFactory((Callback)new PropertyValueFactory("capacity"));
        this.colCapacity.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new IntegerStringConverter()));
        this.colCapacity.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<VehicleModels, Integer>>(){

            public void handle(TableColumn.CellEditEvent<VehicleModels, Integer> t) {
                VehicleModels pl = (VehicleModels)t.getTableView().getItems().get(t.getTablePosition().getRow());
                int capacity = (Integer)t.getNewValue();
                VehicleSetupsController.this.updateVehicleModel(pl.getCode(), pl.getDescription(), pl.getMake().getCode(), capacity, pl.getDailyFee());
            }
        });
        this.dailyFee.setCellValueFactory((Callback)new PropertyValueFactory("dailyFee"));
        this.dailyFee.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new DoubleStringConverter()));
        this.dailyFee.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<VehicleModels, Double>>(){

            public void handle(TableColumn.CellEditEvent<VehicleModels, Double> t) {
                VehicleModels pl = (VehicleModels)t.getTableView().getItems().get(t.getTablePosition().getRow());
                double dailyFee = (Double)t.getNewValue();
                VehicleSetupsController.this.updateVehicleModel(pl.getCode(), pl.getDescription(), pl.getMake().getCode(), pl.getCapacity(), dailyFee);
            }
        });
        Platform.runLater(() -> {
            ObservableList<VehicleMakes> allVehiclemakes = new VehicleMakes().getAllMakes(this.getUser());
            this.colMake.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<VehicleModels, VehicleMakes>, ObservableValue<VehicleMakes>>(){

                public ObservableValue<VehicleMakes> call(TableColumn.CellDataFeatures<VehicleModels, VehicleMakes> param) {
                    VehicleModels model = (VehicleModels)param.getValue();
                    VehicleMakes selectedMake = model.getMake();
                    return new SimpleObjectProperty((Object)selectedMake);
                }
            });
            this.colMake.setCellFactory(ComboBoxTableCell.forTableColumn(allVehiclemakes));
            this.colMake.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<VehicleModels, VehicleMakes>>(){

                public void handle(TableColumn.CellEditEvent<VehicleModels, VehicleMakes> t) {
                    VehicleModels pl = (VehicleModels)t.getTableView().getItems().get(t.getTablePosition().getRow());
                    VehicleMakes myMake = (VehicleMakes)t.getNewValue();
                    VehicleSetupsController.this.updateVehicleModel(pl.getCode(), pl.getDescription(), myMake.getCode(), pl.getCapacity(), pl.getDailyFee());
                }
            });
            this.vehicleFees.setItems(new VehicleFees().getAllStandardFees(this.getUser()));
        });
        this.feeDescription.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.feeAmount.setCellValueFactory((Callback)new PropertyValueFactory("amount"));
        this.feeAmount.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new DoubleStringConverter()));
        this.feeAmount.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<VehicleFees, Double>>(){

            public void handle(TableColumn.CellEditEvent<VehicleFees, Double> t) {
                VehicleFees pl = (VehicleFees)t.getTableView().getItems().get(t.getTablePosition().getRow());
                double amount = (Double)t.getNewValue();
                System.out.println(pl.getCode() + " Am here");
                String url = "vehiclesetupjoiningfee";
                if (pl.getCode() != 1) {
                    if (pl.getCode() == 2) {
                        url = "vehiclesetupdailyfee";
                    } else if (pl.getCode() == 3) {
                        url = "vehiclesetupmonthlyfee";
                    } else if (pl.getCode() == 4) {
                        url = "vehiclesetupnoobjectionfee";
                    }
                }
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("amount", amount);
                    String response = Config.loadDataFromPhp("masterupdate?type=" + url, params, VehicleSetupsController.this.getUser());
                    Gson g = new Gson();
                    JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                    VehicleSetupsController.this.notificationPane.setText(jr.getMessage());
                    VehicleSetupsController.this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    VehicleSetupsController.this.notificationPane.show();
                }
                catch (Exception e) {
                    VehicleSetupsController.this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                    VehicleSetupsController.this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    VehicleSetupsController.this.notificationPane.show();
                    e.printStackTrace();
                }
            }
        });
    }

    public void loadVehicleMakes() {
        Platform.runLater(() -> {
            this.vehicleMakes.setItems(new VehicleMakes().getAllMakes(this.getUser()));
            this.vehicleMakes.getItems().add((Object)new VehicleMakes(0, ""));
            this.loadVehicleModels();
        });
    }

    public void loadVehicleModels() {
        Platform.runLater(() -> {
            this.allModels.setItems(new VehicleModels().getAllModels(this.getUser()));
            this.allModels.getItems().add((Object)new VehicleModels(0, "", new VehicleMakes(), 0, 0.0));
        });
    }

    public void updateVehicleModel(int modelCode, String modelName, int make, double capacity, double dailyFee) {
        try {
            this.notificationPane.hide();
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("Code", modelCode);
            params.put("Model", modelName);
            params.put("Make", make);
            params.put("Capacity", capacity);
            params.put("DailyFee", dailyFee);
            String response = Config.loadDataFromPhp("mastercreate?type=vehiclemodel", params, this.getUser());
            System.out.println(response);
            Gson g = new Gson();
            JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                this.loadVehicleModels();
            }
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            this.loadVehicleMakes();
        }
        catch (Exception r) {
            this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }
}

