/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.PostingGroup;
import classes.Region;
import classes.User;
import classes.Vendor;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import sun.misc.BASE64Decoder;

public class VendorCardController
implements Initializable {
    private int numberSeriesCode;
    private Vendor vendor;
    private User user;
    private String vendorType;
    String imagePath = "";
    @FXML
    private VBox root;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private TabPane holder;
    @FXML
    private Label vendorNoLabel;
    @FXML
    private Label investorNo;
    @FXML
    private TextField vendorName;
    @FXML
    private TextField idNumber;
    @FXML
    private TextField phoneNumber;
    @FXML
    private TextField emailAddress;
    @FXML
    private TextField address;
    @FXML
    private ComboBox<PostingGroup> postingGroup;
    @FXML
    private TextField kraPin;
    @FXML
    private DatePicker dateOfBirth;
    @FXML
    private ImageView profilePhoto;
    @FXML
    private TextField bankName;
    @FXML
    private TextField bankBranch;
    @FXML
    private TextField branchCode;
    @FXML
    private TextField bankAccountNo;
    @FXML
    private JFXButton addVendor;
    @FXML
    private JFXButton reset;
    @FXML
    private Tab generalDetailsTab;
    @FXML
    private ComboBox<Region> region;
    @FXML
    private TextField contactPerson;
    @FXML
    private TextField contactPhone;
    @FXML
    private TextField contactPosition;
    @FXML
    private TextField contactEmailAddress;
    @FXML
    private TextArea remarks;

    public int getNumberSeriesCode() {
        return this.numberSeriesCode;
    }

    public void setNumberSeriesCode(int numberSeriesCode) {
        this.numberSeriesCode = numberSeriesCode;
    }

    public Vendor getVendor() {
        return this.vendor;
    }

    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
        this.investorNo.setText(vendor.getVendorNumber());
        this.vendorName.setText(vendor.getName());
        this.idNumber.setText(vendor.getVendorId());
        this.phoneNumber.setText(vendor.getVendorPhone());
        this.emailAddress.setText(vendor.getVendorEmail());
        this.address.setText(vendor.getVendorAddress());
        this.kraPin.setText(vendor.getKraPin());
        this.bankName.setText(vendor.getBankName());
        this.bankBranch.setText(vendor.getBankBranch());
        this.branchCode.setText(vendor.getBranchCode());
        this.bankAccountNo.setText(vendor.getBankAccountNo());
        this.postingGroup.setValue((Object)vendor.getVendorPostingGroup());
        this.contactPerson.setText(vendor.getContactPersonName());
        this.contactPhone.setText(vendor.getContactPersonPhone());
        this.contactEmailAddress.setText(vendor.getContactPersonEmail());
        this.contactPosition.setText(vendor.getContactPersonJobPosition());
        this.remarks.setText(vendor.getRemarks());
        try {
            this.region.setValue((Object)vendor.getRegion());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dateOfBirth.setValue((Object)Config.stringToLocalDate(vendor.getDateOfBirth()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] imageByte = decoder.decodeBuffer(vendor.getVendorImage());
            ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
            Image image = new Image((InputStream)bis);
            this.profilePhoto.setImage(image);
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addVendor.setText("Save Changes");
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.postingGroup.setItems(new PostingGroup().getAllPostingGroups(2, user));
        this.region.setItems(new Region().getAllRegions(user));
    }

    public String getVendorType() {
        return this.vendorType;
    }

    public void setVendorType(String vendorType) {
        this.vendorType = vendorType;
        if (vendorType.equalsIgnoreCase("Investor")) {
            this.addVendor.setText("Add Investor");
            this.generalDetailsTab.setText("Investor Details");
            this.vendorNoLabel.setText("Investor No:");
            this.setNumberSeriesCode(51);
        } else if (vendorType.equalsIgnoreCase("Sales Rep")) {
            this.addVendor.setText("Add Sales Rep");
            this.generalDetailsTab.setText("Sales Rep Details");
            this.vendorNoLabel.setText("Sales Rep No:");
            this.setNumberSeriesCode(52);
        } else if (vendorType.equalsIgnoreCase("General Vendor")) {
            this.addVendor.setText("Add Vendor");
            this.generalDetailsTab.setText("Vendor Details");
            this.vendorNoLabel.setText("Vendor No:");
            this.setNumberSeriesCode(10);
        } else if (vendorType.equalsIgnoreCase("landlord")) {
            this.addVendor.setText("Add Landlord");
            this.generalDetailsTab.setText("Landlord Details");
            this.vendorNoLabel.setText("Landlord No:");
            this.setNumberSeriesCode(53);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.addVendor.setDisable(!Config.ERP_MODE);
        String path = System.getProperty("user.dir");
        path = path.replace("\\", "/");
        this.imagePath = path + "/holder.png";
        this.reset.setOnAction(e -> ((Stage)this.reset.getScene().getWindow()).close());
        final ContextMenu imageOptions = new ContextMenu();
        MenuItem upload = new MenuItem("Upload");
        upload.setOnAction(e -> {
            FileChooser chooser = new FileChooser();
            chooser.setTitle("Select Item Picture");
            chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All Images", new String[]{"*.jpg", "*.png"}), new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg"}), new FileChooser.ExtensionFilter("PNG", new String[]{"*.png"})});
            File file = chooser.showOpenDialog((Window)new Stage());
            if (file != null) {
                this.openFile(file);
            }
        });
        MenuItem reset = new MenuItem("Reset to Default");
        String myPath = path;
        reset.setOnAction(e -> {
            String fileLocation = myPath + "/holder.png";
            File imgFile = new File(fileLocation);
            this.openFile(imgFile);
        });
        imageOptions.getItems().addAll((Object[])new MenuItem[]{upload, reset});
        this.profilePhoto.setOnContextMenuRequested((EventHandler)new EventHandler<ContextMenuEvent>(){

            public void handle(ContextMenuEvent event) {
                imageOptions.show((Node)VendorCardController.this.profilePhoto, event.getScreenX(), event.getScreenY());
            }
        });
        ValidationSupport validationSupport = new ValidationSupport();
        validationSupport.registerValidator((Control)this.vendorName, Validator.createEmptyValidator((String)"Company name is required"));
        validationSupport.registerValidator(this.postingGroup, Validator.createEmptyValidator((String)" required"));
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.addVendor.setOnAction(e -> {
            String date;
            String tContactEmailAddress;
            String tContactPosition;
            String tContactPhone;
            String tContactPerson;
            String tRemarks;
            String tBankAccountNo;
            String tBranchCode;
            String tBankBranch;
            String tBankName;
            String tPostingGroup;
            String pin;
            String tAddress;
            String email;
            String phoneNo;
            String idNo;
            String tVendorName;
            this.addVendor.setDisable(true);
            int regionCode = 0;
            try {
                tVendorName = this.vendorName.getText().trim();
            }
            catch (Exception u) {
                tVendorName = "";
            }
            try {
                idNo = this.idNumber.getText().trim();
            }
            catch (Exception y) {
                idNo = "";
            }
            try {
                phoneNo = this.phoneNumber.getText().trim();
            }
            catch (Exception y) {
                phoneNo = "";
            }
            try {
                email = this.emailAddress.getText().trim();
            }
            catch (Exception y) {
                email = "";
            }
            try {
                tAddress = this.address.getText().trim();
            }
            catch (Exception y) {
                tAddress = "";
            }
            try {
                pin = this.kraPin.getText().trim();
            }
            catch (Exception y) {
                pin = "";
            }
            try {
                tPostingGroup = ((PostingGroup)this.postingGroup.getValue()).getCode() + "";
            }
            catch (Exception y) {
                tPostingGroup = "";
            }
            try {
                tBankName = this.bankName.getText().trim();
            }
            catch (Exception y) {
                tBankName = "";
            }
            try {
                tBankBranch = this.bankBranch.getText().trim();
            }
            catch (Exception y) {
                tBankBranch = "";
            }
            try {
                tBranchCode = this.branchCode.getText().trim();
            }
            catch (Exception y) {
                tBranchCode = "";
            }
            try {
                tBankAccountNo = this.bankAccountNo.getText().trim();
            }
            catch (Exception y) {
                tBankAccountNo = "";
            }
            try {
                tRemarks = this.remarks.getText().trim();
            }
            catch (Exception y) {
                tRemarks = "";
            }
            try {
                tContactPerson = this.contactPerson.getText().trim();
            }
            catch (Exception y) {
                tContactPerson = "";
            }
            try {
                tContactPhone = this.contactPhone.getText().trim();
            }
            catch (Exception y) {
                tContactPhone = "";
            }
            try {
                tContactPosition = this.contactPosition.getText().trim();
            }
            catch (Exception y) {
                tContactPosition = "";
            }
            try {
                tContactEmailAddress = this.contactEmailAddress.getText().trim();
            }
            catch (Exception y) {
                tContactEmailAddress = "";
            }
            try {
                regionCode = ((Region)this.region.getValue()).getId();
            }
            catch (Exception y) {
                regionCode = 0;
            }
            try {
                LocalDate dob = (LocalDate)this.dateOfBirth.getValue();
                date = Config.localDateToString(dob);
            }
            catch (Exception t) {
                date = "";
            }
            ObservableList requiredFields = FXCollections.observableArrayList((Object[])new String[]{tVendorName, phoneNo, tPostingGroup, date});
            ObservableList requiredHeaders = FXCollections.observableArrayList((Object[])new String[]{"Company Name", "Phone No", "Vendor Posting Group", "Reg. Date"});
            int[] lengths = new int[]{3, 0, 1, 6};
            JsonResponses jr = new Config().checkRequiredFields((ObservableList<String>)requiredFields, (ObservableList<String>)requiredHeaders, lengths);
            if (!jr.isStatus()) {
                try {
                    this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    this.notificationPane.setText("Adding Vendor. Please wait...");
                    this.notificationPane.show();
                    String vendorNumber = "";
                    boolean newVendor = false;
                    System.out.println("Series Code " + this.getNumberSeriesCode());
                    NumberSeries nb = new NumberSeries(this.getNumberSeriesCode(), this.getUser());
                    try {
                        if (this.investorNo.getText().trim().length() < 1) {
                            throw new Exception();
                        }
                        vendorNumber = this.investorNo.getText().trim();
                    }
                    catch (Exception u) {
                        newVendor = true;
                        vendorNumber = nb.getNextNumber();
                    }
                    ByteArrayOutputStream ba = Config.convertFileToJson(this.imagePath);
                    String photoJson = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])ba.toByteArray()));
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("vendorNumber", vendorNumber);
                    params.put("name", tVendorName);
                    params.put("idNo", idNo);
                    params.put("phoneNo", phoneNo);
                    params.put("email", email);
                    params.put("address", tAddress);
                    params.put("pin", pin);
                    params.put("dob", date);
                    params.put("bankName", tBankName);
                    params.put("bankBranch", tBankBranch);
                    params.put("branchCode", tBranchCode);
                    params.put("bankAccountNo", tBankAccountNo);
                    params.put("postingGroup", tPostingGroup);
                    params.put("vendorType", this.getVendorType());
                    params.put("region", regionCode);
                    params.put("remarks", tRemarks);
                    params.put("contactPerson", tContactPerson);
                    params.put("contactPhone", tContactPhone);
                    params.put("contactPosition", tContactPosition);
                    params.put("contactEmailAddress", tContactEmailAddress);
                    Gson g = new Gson();
                    String url = "mastercreate?type=vendor";
                    if (!newVendor) {
                        url = "masterupdate?type=vendor";
                    } else {
                        params.put("photo", photoJson);
                    }
                    String response2 = Config.loadDataFromPhp(url, params, this.getUser());
                    System.out.println(response2);
                    JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                    this.notificationPane.setText(myResponse.getMessage());
                    this.notificationPane.setGraphic((Node)myResponse.getIconFromStatus());
                    this.notificationPane.show();
                    if (myResponse.isStatus() && newVendor) {
                        nb.updateLastUsed(vendorNumber);
                        this.investorNo.setText(vendorNumber);
                    }
                    this.addVendor.setDisable(false);
                }
                catch (Exception t) {
                    this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.addVendor.setDisable(false);
                }
            } else {
                this.addVendor.setDisable(false);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        });
    }

    public void clear() {
        this.investorNo.setText(null);
        this.vendorName.setText(null);
        this.idNumber.setText(null);
        this.phoneNumber.setText(null);
        this.emailAddress.setText(null);
        this.dateOfBirth.setValue(null);
        this.kraPin.setText(null);
        this.bankName.setText(null);
        this.bankBranch.setText(null);
        this.branchCode.setText(null);
        this.bankAccountNo.setText(null);
        this.postingGroup.setValue(null);
        this.region.setValue(null);
    }

    private void openFile(File file) {
        boolean newVendor = false;
        String vendorNo = "";
        try {
            vendorNo = this.investorNo.getText().trim();
            if (vendorNo.length() <= 0) {
                throw new Exception();
            }
            newVendor = false;
        }
        catch (Exception y) {
            newVendor = true;
        }
        if (newVendor) {
            try {
                Image image = new Image(file.toURI().toString());
                this.profilePhoto.setImage(image);
                this.imagePath = file.getPath();
            }
            catch (Exception image) {}
        } else {
            try {
                Image image = new Image(file.toURI().toString());
                try {
                    Image image2 = new Image(file.toURI().toString());
                    ImageView loader = new ImageView(image2);
                    loader.setFitHeight(30.0);
                    loader.setFitWidth(30.0);
                    this.notificationPane.setGraphic((Node)loader);
                    this.notificationPane.getStyleClass().add((Object)"dark");
                    this.notificationPane.setText("Updating investor photo. Please wait...");
                    this.notificationPane.show();
                    ByteArrayOutputStream ba = Config.convertFileToJson(file.getPath());
                    String photoJson = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])ba.toByteArray()));
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("vendorNumber", vendorNo);
                    params.put("photo", photoJson);
                    Gson g = new Gson();
                    String response2 = Config.loadDataFromPhp("masterupdate?type=vendorprofilephoto", params, this.getUser());
                    JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                    if (myResponse.isStatus()) {
                        this.notificationPane.setText(myResponse.getMessage());
                        this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                    } else {
                        this.notificationPane.setText(myResponse.getMessage());
                        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    }
                    this.addVendor.setDisable(false);
                    this.profilePhoto.setImage(image);
                }
                catch (Exception t) {
                    t.printStackTrace();
                    this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.addVendor.setDisable(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

