/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.Investment;
import classes.JsonResponses;
import classes.User;
import classes.Withdrawal;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class WithdrawCapitalController
implements Initializable {
    private User user;
    private Withdrawal withdrawal;
    @FXML
    private Label entryNo;
    @FXML
    private TextField amount;
    @FXML
    private TextField paymentRef;
    @FXML
    private AnchorPane root;
    @FXML
    private AnchorPane holder;
    @FXML
    private ComboBox<Bank> bankName;
    @FXML
    private ComboBox<Investment> investment;
    @FXML
    private DatePicker withdrawalDate;
    @FXML
    private JFXButton post;
    @FXML
    private JFXButton reset;
    @FXML
    private NotificationPane notificationPane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Withdrawal getWithdrawal() {
        return this.withdrawal;
    }

    public void setWithdrawal(Withdrawal withdrawal) {
        this.withdrawal = withdrawal;
        this.entryNo.setText(withdrawal.getEntryNo() + "");
        this.amount.setText(Config.formatNumber(withdrawal.getAmount()));
        this.paymentRef.setText(withdrawal.getPaymentRef());
        this.bankName.setValue((Object)withdrawal.getBankName());
        this.investment.setValue((Object)withdrawal.getInvestment());
        this.withdrawalDate.setValue((Object)Config.stringToLocalDate(withdrawal.getWithdrawalDate()));
        this.disableFields();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.withdrawalDate.setValue((Object)Config.getCurrentLocaldate());
        this.bankName.setItems(Bank.getAllBanks(this.getUser()));
        this.investment.setItems(new Investment().getAllInvestments(this.getUser()));
        this.amount = new Config().setDoubleTextField(this.amount);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.amount, Validator.createEmptyValidator((String)"Amount is Required"));
        vs.registerValidator(this.bankName, Validator.createEmptyValidator((String)"Bank is Required"));
        vs.registerValidator(this.investment, Validator.createEmptyValidator((String)"Investment is Required"));
        vs.registerValidator((Control)this.withdrawalDate, Validator.createEmptyValidator((String)"Withdrawal Date is Required"));
        this.reset.setOnAction(e -> {
            Stage stage = (Stage)this.reset.getScene().getWindow();
            stage.close();
        });
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.post.setOnAction(e -> {
            String tEntryNo = this.entryNo.getText().trim();
            double tAmount = 0.0;
            String tPaymentRef = this.paymentRef.getText().trim();
            int tBank = 0;
            String tInvestmentNo = "";
            String tWithdrawalDate = "";
            boolean error = false;
            String message = "";
            if (tEntryNo.length() > 0) {
                this.notificationPane.setText("The withdrawal addition has already been posted. ");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            } else {
                try {
                    tAmount = Double.parseDouble(this.amount.getText().trim());
                }
                catch (Exception t) {
                    error = true;
                    message = "Please enter a valid value for amount";
                }
                try {
                    tBank = ((Bank)this.bankName.getValue()).getCode();
                }
                catch (Exception t) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select the bank receiving the payment";
                }
                try {
                    tInvestmentNo = ((Investment)this.investment.getValue()).getInvestmentNo();
                }
                catch (Exception t) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select the investment";
                }
                try {
                    tWithdrawalDate = Config.localDateToString((LocalDate)this.withdrawalDate.getValue());
                }
                catch (Exception t) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select the payment date";
                }
                if (error) {
                    this.notificationPane.setText(message);
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                } else {
                    try {
                        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                        params.put("amount", tAmount);
                        params.put("paymentRef", tPaymentRef);
                        params.put("bank", tBank);
                        params.put("investmentNo", tInvestmentNo);
                        params.put("withdrawalDate", tWithdrawalDate);
                        String response = Config.loadDataFromPhp("mastercreate?type=investmentwithdrawal", params, this.getUser());
                        System.out.println(response);
                        JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                        this.notificationPane.setText(jr.getMessage());
                        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                        this.notificationPane.show();
                        if (jr.isStatus()) {
                            this.entryNo.setText(jr.getOverLoad1());
                            this.disableFields();
                        }
                    }
                    catch (Exception t) {
                        this.notificationPane.setText("We encountered an error while processing your request");
                        this.notificationPane.setGraphic((Node)Config.getBanIcon());
                        this.notificationPane.show();
                    }
                }
            }
        });
    }

    private void disableFields() {
        this.post.setDisable(true);
        this.amount.setDisable(true);
        this.paymentRef.setDisable(true);
        this.bankName.setDisable(true);
        this.investment.setDisable(true);
        this.withdrawalDate.setDisable(true);
    }
}

