/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Account;
import classes.Config;
import classes.Employee;
import classes.FixedAssets;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import sun.misc.BASE64Decoder;

public class addAssetController
implements Initializable {
    private User user;
    FixedAssets asset;
    String imagePath = "";
    @FXML
    private HBox holder;
    @FXML
    private TextField assetSerialNumber;
    @FXML
    private DatePicker dateAcquired;
    @FXML
    private TextArea assetDescription;
    @FXML
    private ImageView assetImage;
    @FXML
    private JFXButton addAsset;
    @FXML
    private JFXButton reset;
    @FXML
    private ComboBox<Employee> assignedTo;
    @FXML
    private ComboBox<Account> acquisitionGlAccount;
    @FXML
    private ComboBox<Account> apprDeprGlAccount;
    @FXML
    private TextField assetlocation;
    @FXML
    private Label fixedAssetNo;
    @FXML
    private TextField faName;
    @FXML
    private NotificationPane notificationPane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        Employee employee = new Employee();
        employee.setEmployeeNumber("");
        Platform.runLater(() -> {
            ObservableList<Account> allAccounts = Account.getAccounts(user);
            this.apprDeprGlAccount.setItems(allAccounts);
            this.acquisitionGlAccount.setItems(allAccounts);
            this.assignedTo.getItems().add((Object)employee);
            this.assignedTo.getItems().addAll(new Employee().getAllEmployees(this.getUser()));
        });
    }

    public FixedAssets getAsset() {
        return this.asset;
    }

    public void setAsset(FixedAssets asset) {
        this.asset = asset;
        this.fixedAssetNo.setText(asset.getAssetNo());
        this.faName.setText(asset.getAssetName());
        this.assetSerialNumber.setText(asset.getAssetSerial());
        this.assetDescription.setText(asset.getDescription());
        this.dateAcquired.setValue((Object)Config.stringToLocalDate(asset.getDateAcquired()));
        this.acquisitionGlAccount.setValue((Object)asset.getAcquisitionGLAccount());
        this.apprDeprGlAccount.setValue((Object)asset.getAppreciationGLAccount());
        this.assignedTo.setValue((Object)asset.getAssignedTo());
        this.assetlocation.setText(asset.getLocation());
        try {
            try {
                BASE64Decoder decoder = new BASE64Decoder();
                byte[] imageByte = decoder.decodeBuffer(asset.getAssetPhoto(this.getUser()));
                ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
                Image image = new Image((InputStream)bis);
                this.assetImage.setImage(image);
                bis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize(URL location2, ResourceBundle resources) {
        this.dateAcquired.setValue((Object)Config.getCurrentLocaldate());
        String path = System.getProperty("user.dir");
        path = path.replace("\\", "/");
        this.imagePath = path + "/holder.png";
        this.reset.setOnAction(e -> {
            try {
                String tFa = this.fixedAssetNo.getText().trim();
                if (tFa.length() <= 0) {
                    throw new Exception();
                }
                Stage stage = (Stage)this.reset.getScene().getWindow();
                stage.close();
            }
            catch (Exception y) {
                this.clear();
            }
        });
        final ContextMenu imageOptions = new ContextMenu();
        MenuItem upload = new MenuItem("Upload");
        upload.setOnAction(e -> {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Select Asset Image");
            fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All Images", new String[]{"*.jpg", "*.png"}), new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg"}), new FileChooser.ExtensionFilter("PNG", new String[]{"*.png"})});
            File file = fileChooser.showOpenDialog((Window)new Stage());
            if (file != null) {
                this.openFile(file);
            }
        });
        MenuItem reset = new MenuItem("Reset to default");
        String myPath = path;
        reset.setOnAction(event -> {
            String fileLocation = myPath + "/holder.png";
            File imgFile = new File(fileLocation);
            this.openFile(imgFile);
        });
        imageOptions.getItems().addAll((Object[])new MenuItem[]{upload, reset});
        this.assetImage.setOnContextMenuRequested((EventHandler)new EventHandler<ContextMenuEvent>(){

            public void handle(ContextMenuEvent event) {
                imageOptions.show((Node)addAssetController.this.assetImage, event.getScreenX(), event.getScreenY());
            }
        });
        ValidationSupport validationSupport = new ValidationSupport();
        validationSupport.registerValidator((Control)this.assetSerialNumber, Validator.createEmptyValidator((String)"Please insert asset serial"));
        validationSupport.registerValidator((Control)this.dateAcquired, Validator.createEmptyValidator((String)"Please insert acquired date"));
        validationSupport.registerValidator((Control)this.faName, Validator.createEmptyValidator((String)"Please enter the fixed asset name"));
        validationSupport.registerValidator((Control)this.assetlocation, Validator.createEmptyValidator((String)"Where's the item located?"));
        validationSupport.registerValidator(this.acquisitionGlAccount, Validator.createEmptyValidator((String)"Required"));
        validationSupport.registerValidator(this.apprDeprGlAccount, Validator.createEmptyValidator((String)"Required"));
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.addAsset.setOnAction(event -> {
            String tAssetName = this.faName.getText().trim();
            String description = this.assetDescription.getText().trim();
            String serialNumber = this.assetSerialNumber.getText().trim();
            String date = "";
            String faNo = "";
            NumberSeries nb = new NumberSeries(27, this.getUser());
            String location = this.assetlocation.getText().trim();
            String tAcquisitionGlAccount = "";
            String tApprDeprGlAccount = "";
            String assignedEployee = null;
            boolean error = false;
            boolean newAsset = false;
            String message = "";
            try {
                assignedEployee = ((Employee)this.assignedTo.getValue()).getEmployeeNumber();
            }
            catch (Exception er) {
                assignedEployee = null;
            }
            try {
                date = Config.localDateToString((LocalDate)this.dateAcquired.getValue());
            }
            catch (Exception e) {
                error = true;
                message = "Please select a valid date acquired";
            }
            if (tAssetName.length() < 1) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter the asset name";
            }
            if (location.length() < 1) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter the asset location";
            }
            try {
                tAcquisitionGlAccount = ((Account)this.acquisitionGlAccount.getValue()).getAccountNumber();
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select the asset's Acquisition G/L Account";
            }
            try {
                tApprDeprGlAccount = ((Account)this.apprDeprGlAccount.getValue()).getAccountNumber();
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select the asset's Appreciation or Depreciation  G/L Account";
            }
            try {
                faNo = this.fixedAssetNo.getText().trim();
                if (faNo.length() < 1) {
                    throw new Exception();
                }
            }
            catch (Exception y) {
                faNo = nb.getNextNumber();
                newAsset = true;
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else {
                try {
                    ByteArrayOutputStream ba = Config.convertFileToJson(this.imagePath);
                    String photoJson = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])ba.toByteArray()));
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("faNo", faNo);
                    params.put("faName", tAssetName);
                    params.put("description", description);
                    params.put("serialNumber", serialNumber);
                    params.put("acquireDdate", date);
                    params.put("location", location);
                    params.put("assignedTo", assignedEployee);
                    params.put("acquisitionGlAccount", tAcquisitionGlAccount);
                    params.put("apprDeprGlAccount", tApprDeprGlAccount);
                    params.put("image", photoJson);
                    Gson g = new Gson();
                    String response2 = Config.loadDataFromPhp("mastercreate?type=fixedasset", params, this.getUser());
                    System.out.println(response2);
                    JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                    this.notificationPane.setText(myResponse.getMessage());
                    this.notificationPane.setGraphic((Node)myResponse.getIconFromStatus());
                    this.notificationPane.show();
                    if (myResponse.isStatus() && newAsset) {
                        nb.updateLastUsed(faNo);
                        Stage stage = (Stage)this.addAsset.getScene().getWindow();
                        stage.close();
                    }
                    this.addAsset.setDisable(false);
                }
                catch (Exception e) {
                    this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.addAsset.setDisable(false);
                    e.printStackTrace();
                }
            }
        });
    }

    public void clear() {
        this.assetSerialNumber.setText(null);
        this.dateAcquired.setValue(null);
        this.assetDescription.setText(null);
        this.assetlocation.setText(null);
    }

    private void openFile(File file) {
        try {
            Image image = new Image(file.toURI().toString());
            this.assetImage.setImage(image);
            this.imagePath = file.getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removenotif() {
        PauseTransition pauseTransition = new PauseTransition(Duration.seconds((double)2.0));
        pauseTransition.setOnFinished(e -> this.notificationPane.hide());
        pauseTransition.play();
    }
}

