/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Capital;
import classes.User;
import com.jfoenix.controls.JFXButton;
import controllers.AddCapitalController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;

public class allCapitalController
implements Initializable {
    private User user;
    @FXML
    private VBox root;
    @FXML
    private SplitPane splitPane;
    @FXML
    private AnchorPane details;
    @FXML
    private JFXButton addCapital;
    @FXML
    private JFXButton editCapital;
    @FXML
    private JFXButton delete;
    @FXML
    private JFXButton refresh;
    @FXML
    private JFXButton capitalStatement;
    @FXML
    private JFXButton allCapital;
    @FXML
    private TableView<Capital> allCapitalTable;
    @FXML
    private TableColumn bankName;
    @FXML
    private TableColumn investment;
    @FXML
    private TableColumn amount;
    @FXML
    private TableColumn investmentDate;
    @FXML
    private MaskerPane masker;
    @FXML
    private HBox searchBox;
    @FXML
    private TextField searchBar;
    @FXML
    private JFXButton clearFilter;
    @FXML
    private AnchorPane preview;
    @FXML
    private AnchorPane previewCapital;
    @FXML
    private Label previewBank;
    @FXML
    private Label previewInvestment;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.loadItems();
        this.bankName.setCellValueFactory((Callback)new PropertyValueFactory("bankName"));
        this.investment.setCellValueFactory((Callback)new PropertyValueFactory("investment"));
        this.amount.setCellValueFactory((Callback)new PropertyValueFactory("amountString"));
        this.investmentDate.setCellValueFactory((Callback)new PropertyValueFactory("investmentDate"));
        this.refresh.setOnAction(e -> this.loadItems());
        this.addCapital.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/addCapital.fxml").openStream());
                AddCapitalController controller = (AddCapitalController)loader.getController();
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent event) {
                        KeyCode key = event.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                allCapitalController.this.loadItems();
                            }
                        });
                    }
                });
                stage.setScene(scene);
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setTitle("Add Capital");
                stage.show();
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        });
        this.allCapitalTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    Capital rowData = (Capital)row.getItem();
                    Capital capital = (Capital)this.allCapitalTable.getSelectionModel().getSelectedItem();
                    if (!this.investment.equals(null)) {
                        this.editCapital(capital);
                    }
                }
            });
            return row;
        });
        this.editCapital.setOnAction(r -> {
            try {
                Capital capital = (Capital)this.allCapitalTable.getSelectionModel().getSelectedItem();
                if (!capital.equals(null) && !capital.getBankName().equals("")) {
                    this.editCapital(capital);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
    }

    private void editCapital(Capital capital) {
        try {
            FXMLLoader loader = new FXMLLoader();
            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/addCapital.fxml").openStream());
            Scene editMember = new Scene((Parent)itemPane, 458.0, 342.0);
            final Stage editCapitalStage = new Stage();
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        editCapitalStage.close();
                    }
                }
            });
            editCapitalStage.setScene(editMember);
            AddCapitalController controller = (AddCapitalController)loader.getController();
            controller.setUser(this.getUser());
            controller.setCapital(capital);
            editCapitalStage.setTitle("Edit Capital");
            editCapitalStage.setResizable(false);
            try {
                editCapitalStage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            editCapitalStage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            allCapitalController.this.loadItems();
                        }
                    });
                }
            });
            editCapitalStage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your Investments screen. Please contact support");
            alert.showAndWait();
        }
    }

    private void loadItems() {
        Platform.runLater(() -> {
            this.masker.setVisible(true);
            ObservableList<Capital> allcapitallist = new Capital().getAllCapital(false, this.getUser());
            this.allCapitalTable.setItems(allcapitallist);
            this.masker.setVisible(false);
        });
    }
}

