/*
 * Decompiled with CFR 0.152.
 */
package etims;

import classes.Config;
import classes.Customer;
import classes.JsonResponses;
import classes.ShopItem;
import classes.ShopLocation;
import classes.User;
import com.google.gson.Gson;
import java.awt.Desktop;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.MapValueFactory;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class ETimsController
implements Initializable {
    private String t_kraPin;
    private HashMap importsData = null;
    private ObservableList<ShopLocation> allBranches;
    private User user;
    @FXML
    private ListView<String> etimsItems;
    @FXML
    private VBox contentPane;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private VBox initializeVBox;
    @FXML
    private TextField jarFile;
    @FXML
    private Button selectJarFile;
    @FXML
    private TextField etimsServer;
    @FXML
    private TextField kraPin;
    @FXML
    private ComboBox<ShopLocation> branchId;
    @FXML
    private ComboBox<ShopLocation> branch;
    @FXML
    private TextField serialNo;
    @FXML
    private Button initializeEtims;
    @FXML
    private Button startServer;
    @FXML
    private Button saveChanges;
    @FXML
    private VBox tableVbox;
    @FXML
    private TextField search;
    @FXML
    private Button refresh;
    @FXML
    private Button addRecord;
    @FXML
    private TableView<HashMap> allItems;
    @FXML
    private VBox branchUserVBox;
    @FXML
    private ComboBox<ShopLocation> branchUserBranchId;
    @FXML
    private TextField branchUserUserId;
    @FXML
    private TextField branchUserUserName;
    @FXML
    private TextField branchUserPassword;
    @FXML
    private TextField branchUserAddress;
    @FXML
    private TextField branchUserContact;
    @FXML
    private TextField branchUserAuthCd;
    @FXML
    private TextField branchUserRemark;
    @FXML
    private TextField branchUserUseYN;
    @FXML
    private TextField branchUserRegrNm;
    @FXML
    private TextField branchUserRegrId;
    @FXML
    private TextField branchUserModrNm;
    @FXML
    private TextField branchUserModrId;
    @FXML
    private Button branchUserAddUser;
    @FXML
    private VBox branchInsurance;
    @FXML
    private ComboBox<ShopLocation> branchInsuranceBranchId;
    @FXML
    private TextField branchInsuranceInsuranceCode;
    @FXML
    private TextField branchInsuranceInsuranceName;
    @FXML
    private TextField branchInsuranceIsrcRt;
    @FXML
    private TextField branchInsuranceUseYN;
    @FXML
    private TextField branchInsuranceRegrNm;
    @FXML
    private TextField branchInsuranceRegrId;
    @FXML
    private TextField branchInsuranceModrNm;
    @FXML
    private TextField branchInsuranceModrId;
    @FXML
    private Button branchUserAddInsurance;
    @FXML
    private VBox updateImportsVBox;
    @FXML
    private Button searchItem;
    @FXML
    private ComboBox<ShopLocation> importsBranchId;
    @FXML
    private TextField importsTaskCd;
    @FXML
    private TextField importsDclDe;
    @FXML
    private TextField importsItemSeq;
    @FXML
    private TextField importsHsCd;
    @FXML
    private TextField importsItemCd;
    @FXML
    private TextField importsItemClsCd;
    @FXML
    private TextField importsImptItemSttlsCd;
    @FXML
    private TextField importsRemark;
    @FXML
    private TextField importsModrNm;
    @FXML
    private TextField importsModrId;
    @FXML
    private Button updateImports;
    @FXML
    private VBox stockInOutVBox;
    @FXML
    private ComboBox<ShopLocation> stockInOutBranchId;
    @FXML
    private TextField stockInOutRegType;
    @FXML
    private ComboBox<Customer> stockInOutCustomer;
    @FXML
    private Button searchCustomer;
    @FXML
    private TextField stockInOutCustomerBHFId;
    @FXML
    private TextField stockInOutSarType;
    @FXML
    private DatePicker stockInOutOccurenceDate;
    @FXML
    private ComboBox<ShopItem> stockInOutItem;
    @FXML
    private DatePicker stockInOutExpiryDate;
    @FXML
    private TextField stockInOutQuantity;
    @FXML
    private TextField stockInOutPrice;
    @FXML
    private Button stockInOutAddItem;
    @FXML
    private TableView<HashMap> allStockInOut;
    @FXML
    private TableColumn colItemCode;
    @FXML
    private TableColumn colItemName;
    @FXML
    private TableColumn colExpiryDate;
    @FXML
    private TableColumn colQuantity;
    @FXML
    private TableColumn colPrice;
    @FXML
    private Button updateStockInOut;
    @FXML
    private MaskerPane loader;
    Callback<TableColumn<HashMap, HashMap>, TableCell<HashMap, HashMap>> noticeCellFactory = new Callback<TableColumn<HashMap, HashMap>, TableCell<HashMap, HashMap>>(){

        public TableCell<HashMap, HashMap> call(TableColumn<HashMap, HashMap> param) {
            TableCell<HashMap, HashMap> cell = new TableCell<HashMap, HashMap>(){
                private final Hyperlink btn = new Hyperlink("Edit");
                {
                    this.btn.setOnAction(e -> {
                        HashMap data = (HashMap)this.getTableView().getItems().get(this.getIndex());
                        this.btn.setVisited(false);
                        System.out.println(data);
                        String link = data.get("dtlUrl").toString();
                        try {
                            URI url = new URI(link);
                            Desktop.getDesktop().browse(url);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }

                public void updateItem(HashMap item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (empty) {
                        this.setGraphic(null);
                    } else {
                        this.btn.setText("View Notice");
                        this.setGraphic((Node)this.btn);
                    }
                }
            };
            return cell;
        }
    };
    Callback<TableColumn<HashMap, HashMap>, TableCell<HashMap, HashMap>> confirmCellFactory = new Callback<TableColumn<HashMap, HashMap>, TableCell<HashMap, HashMap>>(){

        public TableCell<HashMap, HashMap> call(TableColumn<HashMap, HashMap> param) {
            TableCell<HashMap, HashMap> cell = new TableCell<HashMap, HashMap>(){
                private final Hyperlink btn = new Hyperlink("Edit");
                {
                    this.btn.setOnAction(e -> {
                        HashMap data = (HashMap)this.getTableView().getItems().get(this.getIndex());
                        this.btn.setVisited(false);
                        System.out.println(data);
                        String itemCode = data.get("itemCd").toString();
                        String quantity = data.get("sftyQty").toString();
                        TextInputDialog alert = new TextInputDialog(quantity);
                        alert.setTitle("Edit Quantity");
                        alert.setContentText("Edit Quantity");
                        Optional result = alert.showAndWait();
                        result.ifPresent(confirmedQuantity -> ETimsController.this.updateStockLevel((String)confirmedQuantity, itemCode));
                    });
                }

                public void updateItem(HashMap item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (empty) {
                        this.setGraphic(null);
                    } else {
                        double requestedAmount = 0.0;
                        try {
                            requestedAmount = Double.parseDouble(item.get("sftyQty").toString());
                        }
                        catch (Exception y) {
                            requestedAmount = 0.0;
                        }
                        this.btn.setText(Config.formatNumber(requestedAmount));
                        this.setGraphic((Node)this.btn);
                    }
                }
            };
            return cell;
        }
    };
    Callback<TableColumn<HashMap, HashMap>, TableCell<HashMap, HashMap>> updateImportCellFactory = new Callback<TableColumn<HashMap, HashMap>, TableCell<HashMap, HashMap>>(){

        public TableCell<HashMap, HashMap> call(TableColumn<HashMap, HashMap> param) {
            TableCell<HashMap, HashMap> cell = new TableCell<HashMap, HashMap>(){
                private final Hyperlink btn = new Hyperlink("Edit");
                {
                    this.btn.setOnAction(e -> {
                        HashMap data = (HashMap)this.getTableView().getItems().get(this.getIndex());
                        ETimsController.this.updateImports(data);
                    });
                }

                public void updateItem(HashMap item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (empty) {
                        this.setGraphic(null);
                    } else {
                        this.btn.setText("update");
                        this.setGraphic((Node)this.btn);
                    }
                }
            };
            return cell;
        }
    };

    public String getT_kraPin() {
        return this.t_kraPin;
    }

    public void setT_kraPin(String t_kraPin) {
        this.t_kraPin = t_kraPin;
        this.kraPin.setText(t_kraPin);
    }

    public ObservableList<ShopLocation> getAllBranches() {
        return this.allBranches;
    }

    public void setAllBranches(ObservableList<ShopLocation> allBranches) {
        this.allBranches = allBranches;
        this.stockInOutBranchId.setItems(allBranches);
        this.branchId.setItems(allBranches);
        this.branch.setItems(allBranches);
        this.branchUserBranchId.setItems(allBranches);
        this.branchInsuranceBranchId.setItems(allBranches);
        this.importsBranchId.setItems(allBranches);
        this.branchId.setValue(this.branchId.getItems().get(0));
        this.stockInOutBranchId.setValue(this.stockInOutBranchId.getItems().get(0));
        this.branch.setValue(this.branch.getItems().get(0));
        this.branchUserBranchId.setValue(this.branchUserBranchId.getItems().get(0));
        this.branchInsuranceBranchId.setValue(this.branchInsuranceBranchId.getItems().get(0));
        this.importsBranchId.setValue(this.importsBranchId.getItems().get(0));
        this.serialNo.setText(((ShopLocation)this.branchId.getValue()).getEtimsDeviceSerial());
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.loadEtimsDetails();
        this.stockInOutCustomer.setItems(new Customer().getAllCustomers(user));
        this.stockInOutItem.setItems(new ShopItem().getAllItems(user));
    }

    private void updateImports(HashMap data) {
        this.importsData = data;
        this.updateImportsVBox.setVisible(true);
        this.importsBranchId.requestFocus();
        try {
            this.importsTaskCd.setText(data.get("taskCd").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.importsDclDe.setText(data.get("dclDe").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.importsItemSeq.setText(data.get("itemSeq").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.importsHsCd.setText(data.get("hsCd").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.importsImptItemSttlsCd.setText(data.get("imptItemsttsCd").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.branchId.setOnAction(e -> this.serialNo.setText(((ShopLocation)this.branchId.getValue()).getEtimsDeviceSerial()));
        this.branch.setOnAction(e -> this.reloadData(((String)this.etimsItems.getSelectionModel().getSelectedItem()).toLowerCase()));
        this.initializeVBox.managedProperty().bind((ObservableValue)this.initializeVBox.visibleProperty());
        this.tableVbox.managedProperty().bind((ObservableValue)this.tableVbox.visibleProperty());
        this.branchUserVBox.managedProperty().bind((ObservableValue)this.branchUserVBox.visibleProperty());
        this.branchInsurance.managedProperty().bind((ObservableValue)this.branchInsurance.visibleProperty());
        this.stockInOutVBox.managedProperty().bind((ObservableValue)this.stockInOutVBox.visibleProperty());
        this.updateImportsVBox.managedProperty().bind((ObservableValue)this.updateImportsVBox.visibleProperty());
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        ObservableList allMenus = FXCollections.observableArrayList();
        allMenus.add((Object)"Initialize");
        allMenus.add((Object)"Select Codes");
        allMenus.add((Object)"Item Classes");
        allMenus.add((Object)"Branches");
        allMenus.add((Object)"Items");
        allMenus.add((Object)"Fetch Imported Items");
        allMenus.add((Object)"Get Purchases");
        allMenus.add((Object)"Get Stock");
        allMenus.add((Object)"Get Notices");
        allMenus.add((Object)"Stock Move Request");
        allMenus.add((Object)"Branch Users");
        allMenus.add((Object)"Branch Insurance");
        allMenus.add((Object)"Stock In/Out Save Request");
        allMenus.add((Object)"Update Imported Products");
        this.etimsItems.setItems(allMenus);
        this.etimsItems.setOnMouseClicked(event -> this.showContent(((String)this.etimsItems.getSelectionModel().getSelectedItem()).toLowerCase()));
        this.colItemCode.setCellValueFactory((Callback)new MapValueFactory((Object)"itemCode"));
        this.colItemName.setCellValueFactory((Callback)new MapValueFactory((Object)"itemName"));
        this.colExpiryDate.setCellValueFactory((Callback)new MapValueFactory((Object)"quantity"));
        this.colQuantity.setCellValueFactory((Callback)new MapValueFactory((Object)"price"));
        this.colPrice.setCellValueFactory((Callback)new MapValueFactory((Object)"expiryDate"));
        this.initializeVBox.setVisible(false);
        this.branchUserVBox.setVisible(false);
        this.branchInsurance.setVisible(false);
        this.stockInOutVBox.setVisible(false);
        this.updateImportsVBox.setVisible(false);
        this.tableVbox.setVisible(false);
        this.refresh.setOnAction(e -> this.reloadData(((String)this.etimsItems.getSelectionModel().getSelectedItem()).toLowerCase()));
        this.saveChanges.setOnAction(e -> this.updateDetails());
        this.initializeEtims.setOnAction(e -> {
            if (this.updateDetails()) {
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("jarFile", this.jarFile.getText().trim());
                    params.put("etimsServer", this.etimsServer.getText().trim());
                    params.put("kraPin", this.kraPin.getText().trim());
                    params.put("branchId", ((ShopLocation)this.branchId.getValue()).getEtimsBranchCode().trim());
                    params.put("serialNo", this.serialNo.getText().trim());
                    String response = Config.loadDataFromPhp("mastercreate?type=initializeetims", params, this.getUser());
                    System.out.println(response);
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
                catch (Exception u) {
                    u.printStackTrace();
                    this.notificationPane.setText(u.getMessage());
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
        });
        this.selectJarFile.setOnAction(e -> Platform.runLater(() -> {
            FileChooser chooser = new FileChooser();
            chooser.setTitle("Select jar file");
            chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Jar File", new String[]{"*.jar"})});
            try {
                File file = chooser.showOpenDialog((Window)new Stage());
                if (file != null) {
                    this.jarFile.setText(file.getPath());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        this.startServer.setOnAction(p -> {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    Platform.runLater(() -> {
                        ETimsController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                        ETimsController.this.notificationPane.setText("Starting E-tims Server");
                        ETimsController.this.notificationPane.show();
                    });
                    try {
                        Process proc = Runtime.getRuntime().exec("java -jar " + ETimsController.this.jarFile.getText().trim());
                        proc.waitFor();
                        InputStream in = proc.getInputStream();
                        InputStream err = proc.getErrorStream();
                        byte[] b = new byte[in.available()];
                        in.read(b, 0, b.length);
                        System.out.println(new String(b));
                        int year = Config.getCurrentLocaldate().getYear();
                        String[] allOutput = new String(b).split("\n");
                        for (int a = 0; a < allOutput.length; ++a) {
                            String outPut = allOutput[a].trim();
                            try {
                                String subString = outPut.substring(0, 4);
                                if (subString.equals(year + "")) continue;
                                System.out.println("victor" + outPut + "substring" + subString);
                                Platform.runLater(() -> ETimsController.this.notificationPane.setText(ETimsController.this.notificationPane.getText() + "\n" + outPut));
                                continue;
                            }
                            catch (Exception u) {
                                Platform.runLater(() -> ETimsController.this.notificationPane.setText(ETimsController.this.notificationPane.getText() + "\n" + outPut));
                            }
                        }
                        byte[] c = new byte[err.available()];
                        err.read(c, 0, c.length);
                        System.out.println("Error" + new String(c));
                    }
                    catch (Exception u) {
                        u.printStackTrace();
                    }
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
        });
        this.branchUserAddUser.setOnAction(e -> {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("branchId", ((ShopLocation)this.branchUserBranchId.getValue()).getEtimsBranchCode());
            params.put("userId", this.branchUserUserId.getText().trim());
            params.put("userUserName", this.branchUserUserName.getText().trim());
            params.put("userPassword", this.branchUserPassword.getText().trim());
            params.put("userAddress", this.branchUserAddress.getText().trim());
            params.put("userContact", this.branchUserContact.getText().trim());
            params.put("authCd", this.branchUserAuthCd.getText().trim());
            params.put("remark", this.branchUserRemark.getText().trim());
            params.put("useYN", this.branchUserUseYN.getText().trim());
            params.put("regrNm", this.branchUserRegrNm.getText().trim());
            params.put("regrId", this.branchUserRegrId.getText().trim());
            params.put("modrNm", this.branchUserModrNm.getText().trim());
            params.put("modrId", this.branchUserModrId.getText().trim());
            String response = Config.loadDataFromPhp("mastercreate?type=add_etims_user", params, this.getUser());
            System.out.println(response);
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            if (jr.isStatus()) {
                this.clearAddUserFields();
            }
        });
        this.branchUserAddInsurance.setOnAction(e -> {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("branchId", ((ShopLocation)this.branchInsuranceBranchId.getValue()).getEtimsBranchCode());
            params.put("insuranceCode", this.branchInsuranceInsuranceCode.getText().trim());
            params.put("insuranceName", this.branchInsuranceInsuranceName.getText().trim());
            params.put("isrcRt", this.branchInsuranceIsrcRt.getText().trim());
            params.put("useYN", this.branchInsuranceUseYN.getText().trim());
            params.put("regrNm", this.branchInsuranceRegrNm.getText().trim());
            params.put("regrId", this.branchInsuranceRegrId.getText().trim());
            params.put("modrNm", this.branchInsuranceModrNm.getText().trim());
            params.put("modrId", this.branchInsuranceModrId.getText().trim());
            String response = Config.loadDataFromPhp("mastercreate?type=add_etims_insurance", params, this.getUser());
            System.out.println(response);
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            if (jr.isStatus()) {
                this.clearAddInsuranceFields();
            }
        });
        this.searchItem.setOnAction(e -> {
            String response = new Config().getObjectFromSelection("shopitem", this.getUser());
            ShopItem item = (ShopItem)new Gson().fromJson(response, ShopItem.class);
            this.importsItemCd.setText(item.getCode());
            this.importsItemClsCd.setText(item.getClassificationCode());
        });
        this.updateImports.setOnAction(e -> {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("BranchId", ((ShopLocation)this.importsBranchId.getValue()).getEtimsBranchCode());
            params.put("TaskCd", this.importsTaskCd.getText().trim());
            params.put("DclDe", this.importsDclDe.getText().trim());
            params.put("ItemSeq", this.importsItemSeq.getText().trim());
            params.put("HsCd", this.importsHsCd.getText().trim());
            params.put("ItemCd", this.importsItemCd.getText().trim());
            params.put("ItemClsCd", this.importsItemClsCd.getText().trim());
            params.put("ImptItemSttlsCd", this.importsImptItemSttlsCd.getText().trim());
            params.put("Remark", this.importsRemark.getText().trim());
            params.put("ModrNm", this.importsModrNm.getText().trim());
            params.put("ModrId", this.importsModrId.getText().trim());
            params.put("itemNm", this.importsData.get("itemNm"));
            params.put("qty", this.importsData.get("qty"));
            params.put("invcFcurAmt", this.importsData.get("invcFcurAmt"));
            params.put("importsData", new Gson().toJson((Object)this.importsData));
            String response = Config.loadDataFromPhp("mastercreate?type=update_imports", params, this.getUser());
            System.out.println(response);
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            if (jr.isStatus()) {
                this.clearUpdateImportsFields();
                this.updateImportsVBox.setVisible(false);
                this.reloadData(((String)this.etimsItems.getSelectionModel().getSelectedItem()).toLowerCase());
                new Config().editRecord(jr.getOverLoad2(), "purchaseinvoice", new Stage(), this.getUser());
            }
        });
        this.stockInOutAddItem.setOnAction(e -> {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("itemCode", ((ShopItem)this.stockInOutItem.getValue()).getCode());
            item.put("itemName", ((ShopItem)this.stockInOutItem.getValue()).getName());
            item.put("quantity", this.stockInOutQuantity.getText().trim());
            item.put("price", this.stockInOutPrice.getText().trim());
            item.put("expiryDate", Config.localDateToString((LocalDate)this.stockInOutExpiryDate.getValue()));
            this.allStockInOut.getItems().add(item);
        });
        this.updateStockInOut.setOnAction(e -> {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("BranchId", ((ShopLocation)this.stockInOutBranchId.getValue()).getEtimsBranchCode());
            params.put("regType", this.stockInOutRegType.getText().trim());
            params.put("customer", ((Customer)this.stockInOutCustomer.getValue()).getCustomerNumber().trim());
            params.put("customerBHFId", this.stockInOutCustomerBHFId.getText().trim());
            params.put("sarType", this.stockInOutSarType.getText().trim());
            params.put("occurenceDate", Config.localDateToString((LocalDate)this.stockInOutOccurenceDate.getValue()));
            params.put("items", this.allStockInOut.getItems());
            String response = Config.loadDataFromPhp("mastercreate?type=update_stock_in_out", params, this.getUser());
            System.out.println(response);
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
        });
    }

    private void clearUpdateImportsFields() {
        this.importsTaskCd.setText("");
        this.importsDclDe.setText("");
        this.importsItemSeq.setText("");
        this.importsHsCd.setText("");
        this.importsItemCd.setText("");
        this.importsItemClsCd.setText("");
        this.importsImptItemSttlsCd.setText("");
        this.importsRemark.setText("");
        this.importsModrNm.setText("");
        this.importsModrId.setText("");
    }

    private void clearAddInsuranceFields() {
        this.branchInsuranceInsuranceCode.setText("");
        this.branchInsuranceInsuranceName.setText("");
        this.branchInsuranceIsrcRt.setText("");
        this.branchInsuranceUseYN.setText("");
        this.branchInsuranceRegrNm.setText("");
        this.branchInsuranceRegrId.setText("");
        this.branchInsuranceModrNm.setText("");
        this.branchInsuranceModrId.setText("");
    }

    private void showContent(String selectedItem) {
        this.notificationPane.hide();
        switch (selectedItem) {
            case "initialize": {
                this.initializeVBox.setVisible(true);
                this.tableVbox.setVisible(false);
                this.branchUserVBox.setVisible(false);
                this.branchInsurance.setVisible(false);
                this.stockInOutVBox.setVisible(false);
                this.updateImportsVBox.setVisible(false);
                return;
            }
            case "select codes": {
                this.initializeVBox.setVisible(false);
                this.branchUserVBox.setVisible(false);
                this.branchInsurance.setVisible(false);
                this.stockInOutVBox.setVisible(false);
                this.updateImportsVBox.setVisible(false);
                this.addRecord.setVisible(false);
                this.tableVbox.setVisible(true);
                ObservableList columns = FXCollections.observableArrayList((Object[])new String[]{"cdCls", "cdClsNm", "cd", "cdNm", "userDfnCd1"});
                this.addColumns((ObservableList<String>)columns);
                this.reloadData(selectedItem);
                return;
            }
            case "item classes": {
                this.initializeVBox.setVisible(false);
                this.branchUserVBox.setVisible(false);
                this.branchInsurance.setVisible(false);
                this.updateImportsVBox.setVisible(false);
                this.addRecord.setVisible(false);
                this.tableVbox.setVisible(true);
                ObservableList columns = FXCollections.observableArrayList((Object[])new String[]{"itemClsCd", "itemClsNm", "itemClsLvl", "useYn"});
                this.addColumns((ObservableList<String>)columns);
                this.reloadData(selectedItem);
                return;
            }
            case "branches": {
                this.initializeVBox.setVisible(false);
                this.branchUserVBox.setVisible(false);
                this.branchInsurance.setVisible(false);
                this.stockInOutVBox.setVisible(false);
                this.updateImportsVBox.setVisible(false);
                this.addRecord.setVisible(false);
                this.tableVbox.setVisible(true);
                ObservableList columns = FXCollections.observableArrayList((Object[])new String[]{"tin", "bhfId", "bhfNm", "bhfSttsCd", "prvncNm", "dstrtNm", "sctrNm", "locDesc", "mgrNm", "mgrTelNo", "mgrEmail", "hqYn"});
                this.addColumns((ObservableList<String>)columns);
                this.reloadData(selectedItem);
                this.loadEtimsDetails();
                return;
            }
            case "items": {
                this.initializeVBox.setVisible(false);
                this.branchUserVBox.setVisible(false);
                this.branchInsurance.setVisible(false);
                this.stockInOutVBox.setVisible(false);
                this.updateImportsVBox.setVisible(false);
                this.addRecord.setVisible(false);
                this.tableVbox.setVisible(true);
                ObservableList columns = FXCollections.observableArrayList((Object[])new String[]{"tin", "itemCd", "itemClsCd", "itemTyCd", "itemNm", "itemStdNm", "orgnNatCd", "pkgUnitCd", "qtyUnitCd", "taxTyCd", "btchNo", "regBhfId", "bcd", "dftPrc", "grpPrcL1", "grpPrcL2", "grpPrcL3", "grpPrcL4", "grpPrcL5", "addInfo", "sftyQty", "isrcAplcbYn", "rraModYn", "useYn"});
                this.addColumns((ObservableList<String>)columns);
                TableColumn column = new TableColumn("Update");
                column.setCellFactory(this.confirmCellFactory);
                column.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
                this.allItems.getColumns().add((Object)column);
                this.reloadData(selectedItem);
                return;
            }
            case "fetch imported items": {
                this.initializeVBox.setVisible(false);
                this.branchUserVBox.setVisible(false);
                this.branchInsurance.setVisible(false);
                this.stockInOutVBox.setVisible(false);
                this.updateImportsVBox.setVisible(false);
                this.tableVbox.setVisible(true);
                ObservableList columns = FXCollections.observableArrayList((Object[])new String[]{"taskCd", "dclDe", "itemSeq", "dclNo", "hsCd", "itemNm", "imptItemsttsCd", "orgnNatCd", "exptNatCd", "pkg", "pkgUnitCd", "qty", "qtyUnitCd", "totWt", "netWt", "spplrNm", "agntNm", "invcFcurAmt", "invcFcurCd", "invcFcurExcrt"});
                this.addColumns((ObservableList<String>)columns);
                TableColumn column = new TableColumn("Update");
                column.setCellFactory(this.updateImportCellFactory);
                column.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
                this.allItems.getColumns().add((Object)column);
                this.reloadData(selectedItem);
                return;
            }
            case "get purchases": {
                this.initializeVBox.setVisible(false);
                this.branchUserVBox.setVisible(false);
                this.branchInsurance.setVisible(false);
                this.stockInOutVBox.setVisible(false);
                this.updateImportsVBox.setVisible(false);
                this.addRecord.setVisible(false);
                this.tableVbox.setVisible(true);
                ObservableList columns = FXCollections.observableArrayList((Object[])new String[]{"spplrTin", "spplrNm", "spplrBhfId", "spplrInvcNo", "rcptTyCd", "pmtTyCd", "cfmDt", "salesDt", "totItemCnt", "totTaxblAmt", "totTaxAmt", "totAmt"});
                this.addColumns((ObservableList<String>)columns);
                this.reloadData(selectedItem);
                return;
            }
            case "stock move request": {
                this.initializeVBox.setVisible(false);
                this.branchUserVBox.setVisible(false);
                this.branchInsurance.setVisible(false);
                this.stockInOutVBox.setVisible(false);
                this.updateImportsVBox.setVisible(false);
                this.addRecord.setVisible(false);
                this.tableVbox.setVisible(true);
                ObservableList columns = FXCollections.observableArrayList((Object[])new String[]{"resultCd", "resultMsg", "resultDt"});
                this.addColumns((ObservableList<String>)columns);
                this.reloadData(selectedItem);
                return;
            }
            case "get stock": {
                this.initializeVBox.setVisible(false);
                this.branchUserVBox.setVisible(false);
                this.branchInsurance.setVisible(false);
                this.stockInOutVBox.setVisible(false);
                this.updateImportsVBox.setVisible(false);
                this.addRecord.setVisible(false);
                this.tableVbox.setVisible(true);
                ObservableList columns = FXCollections.observableArrayList((Object[])new String[]{"resultCd", "resultMsg", "resultDt", "data"});
                this.addColumns((ObservableList<String>)columns);
                this.reloadData(selectedItem);
                return;
            }
            case "get notices": {
                this.initializeVBox.setVisible(false);
                this.branchUserVBox.setVisible(false);
                this.branchInsurance.setVisible(false);
                this.updateImportsVBox.setVisible(false);
                this.addRecord.setVisible(false);
                this.tableVbox.setVisible(true);
                ObservableList columns = FXCollections.observableArrayList((Object[])new String[]{"noticeNo", "title", "cont", "dtlUrl", "regrNm", "regDt"});
                this.addColumns((ObservableList<String>)columns);
                TableColumn column = new TableColumn("Open Link");
                column.setCellFactory(this.noticeCellFactory);
                column.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
                this.allItems.getColumns().add((Object)column);
                this.reloadData(selectedItem);
                return;
            }
            case "branch users": {
                this.initializeVBox.setVisible(false);
                this.branchUserVBox.setVisible(true);
                this.branchInsurance.setVisible(false);
                this.stockInOutVBox.setVisible(false);
                this.updateImportsVBox.setVisible(false);
                this.addRecord.setVisible(false);
                this.tableVbox.setVisible(false);
                return;
            }
            case "branch insurance": {
                this.initializeVBox.setVisible(false);
                this.branchUserVBox.setVisible(false);
                this.updateImportsVBox.setVisible(false);
                this.branchInsurance.setVisible(true);
                this.stockInOutVBox.setVisible(false);
                this.addRecord.setVisible(false);
                this.tableVbox.setVisible(false);
                return;
            }
            case "update imported products": {
                this.initializeVBox.setVisible(false);
                this.branchUserVBox.setVisible(false);
                this.updateImportsVBox.setVisible(true);
                this.branchInsurance.setVisible(false);
                this.stockInOutVBox.setVisible(false);
                this.addRecord.setVisible(false);
                this.tableVbox.setVisible(false);
                return;
            }
            case "stock in/out save request": {
                this.initializeVBox.setVisible(false);
                this.branchUserVBox.setVisible(false);
                this.updateImportsVBox.setVisible(false);
                this.branchInsurance.setVisible(false);
                this.stockInOutVBox.setVisible(true);
                this.addRecord.setVisible(false);
                this.tableVbox.setVisible(false);
                return;
            }
        }
        System.out.println(selectedItem);
        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
        this.notificationPane.setText("Option " + selectedItem + " Has not been defined");
        this.notificationPane.show();
    }

    private void addColumns(ObservableList<String> columns) {
        try {
            this.allItems.getColumns().removeAll((Collection)this.allItems.getColumns());
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String current : columns) {
            TableColumn column = new TableColumn(current);
            column.setCellValueFactory((Callback)new MapValueFactory((Object)current));
            this.allItems.getColumns().add((Object)column);
        }
    }

    private void reloadData(final String selectedItem) {
        try {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    Platform.runLater(() -> ETimsController.this.loader.setVisible(true));
                    ObservableList allEntries = null;
                    try {
                        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                        params.put("selectedItem", selectedItem);
                        params.put("branchId", ((ShopLocation)ETimsController.this.branch.getValue()).getEtimsBranchCode());
                        String response = Config.loadDataFromPhp("masterfetch?type=etimsdata", params, ETimsController.this.getUser());
                        System.out.println(response);
                        allEntries = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, HashMap[].class)));
                    }
                    catch (Exception u) {
                        u.printStackTrace();
                    }
                    ObservableList finalAllEntries = allEntries;
                    Platform.runLater(() -> {
                        ETimsController.this.allItems.setItems(finalAllEntries);
                        ETimsController.this.loader.setVisible(false);
                    });
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
        }
        catch (Exception u) {
            u.printStackTrace();
        }
    }

    private void loadEtimsDetails() {
        try {
            String response = Config.loadDataFromPhp("masterfetch?type=etimsdetails", new LinkedHashMap<String, Object>(), this.getUser());
            HashMap params = (HashMap)new Gson().fromJson(response, HashMap.class);
            this.jarFile.setText(params.get("jarFile").toString());
            this.etimsServer.setText(params.get("etimsServer").toString());
            String allBranches = params.get("branches").toString();
            this.setT_kraPin(params.get("kraPin").toString());
            System.out.println(allBranches);
            ObservableList myBranches = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(allBranches, ShopLocation[].class)));
            this.setAllBranches((ObservableList<ShopLocation>)myBranches);
        }
        catch (Exception u) {
            u.printStackTrace();
        }
    }

    public boolean updateDetails() {
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("jarFile", this.jarFile.getText().trim());
            params.put("etimsServer", this.etimsServer.getText().trim());
            params.put("kraPin", this.kraPin.getText().trim());
            params.put("branchId", ((ShopLocation)this.branchId.getValue()).getEtimsBranchCode());
            params.put("serialNo", this.serialNo.getText().trim());
            String response = Config.loadDataFromPhp("mastercreate?type=etimsdetails", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            if (jr.isStatus()) {
                // empty if block
            }
            return jr.isStatus();
        }
        catch (Exception u) {
            u.printStackTrace();
            this.notificationPane.setText(u.getMessage());
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
            return false;
        }
    }

    public void updateStockLevel(String confirmedQuantity, String itemCode) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("itemCode", itemCode);
        params.put("confirmedQuantity", confirmedQuantity);
        String response = Config.loadDataFromPhp("mastercreate?type=update_etims_stock", params, this.getUser());
        System.out.println(response);
        JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
        this.notificationPane.setText(jr.getMessage());
        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
        this.notificationPane.show();
        if (jr.isStatus()) {
            this.reloadData(((String)this.etimsItems.getSelectionModel().getSelectedItem()).toLowerCase());
        }
    }

    public void clearAddUserFields() {
        this.branchUserUserId.setText("");
        this.branchUserUserName.setText("");
        this.branchUserPassword.setText("");
        this.branchUserAddress.setText("");
        this.branchUserContact.setText("");
        this.branchUserAuthCd.setText("");
        this.branchUserRemark.setText("");
        this.branchUserUseYN.setText("");
        this.branchUserRegrNm.setText("");
        this.branchUserRegrId.setText("");
        this.branchUserModrNm.setText("");
        this.branchUserModrId.setText("");
    }
}

