/*
 * Decompiled with CFR 0.152.
 */
package filterscontrollers;

import classes.Config;
import classes.ItemBrand;
import classes.PostingGroup;
import classes.Region;
import classes.ShopLocation;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import org.controlsfx.control.CheckComboBox;

public class AllItemsFilterController
implements Initializable {
    private User user;
    private String reportName;
    @FXML
    private CheckComboBox<PostingGroup> postingGroup;
    @FXML
    private HBox itemBrandHbox;
    @FXML
    private CheckComboBox<ItemBrand> itemBrands;
    @FXML
    private Button cancelItemBrand;
    @FXML
    private CheckComboBox<ShopLocation> warehouse;
    @FXML
    private DatePicker date;
    @FXML
    private Button generate;
    @FXML
    private HBox groupHbox;
    @FXML
    private HBox warehouseHbox;
    @FXML
    private HBox startDateHbox;
    @FXML
    private DatePicker startDate;
    @FXML
    private HBox endDateHbox;
    @FXML
    private DatePicker endDate;
    @FXML
    private HBox dateHbox;
    @FXML
    private Button cancelGroup;
    @FXML
    private Button cancelWarehouse;
    @FXML
    private HBox singleWarehouseHbox;
    @FXML
    private HBox frequencyHBox;
    @FXML
    private ComboBox<String> frequency;
    @FXML
    private ComboBox<ShopLocation> singleWarehouse;
    @FXML
    private HBox regionHBox;
    @FXML
    private CheckComboBox<Region> region;
    @FXML
    private Button cancelRegion;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
        boolean loadPostingGroups = true;
        boolean loadWarehouses = true;
        boolean loadRegions = false;
        if (reportName.equalsIgnoreCase("price_list")) {
            loadWarehouses = false;
            this.dateHbox.setVisible(false);
        } else if (reportName.equalsIgnoreCase("product_margins")) {
            loadWarehouses = false;
            this.dateHbox.setVisible(false);
            this.startDateHbox.setVisible(true);
            this.endDateHbox.setVisible(true);
            this.loadRegions();
        } else if (reportName.equalsIgnoreCase("sales_per_sales_rep") || reportName.equalsIgnoreCase("region_sales_report") || reportName.equalsIgnoreCase("region_sales_per_product")) {
            loadWarehouses = false;
            this.dateHbox.setVisible(false);
            this.startDateHbox.setVisible(true);
            this.endDateHbox.setVisible(true);
        } else if (reportName.equalsIgnoreCase("allassets")) {
            loadWarehouses = false;
            this.dateHbox.setVisible(false);
            this.startDateHbox.setVisible(false);
            this.endDateHbox.setVisible(true);
            loadPostingGroups = false;
        } else if (reportName.equalsIgnoreCase("sales_per_posting_group")) {
            loadWarehouses = false;
            this.dateHbox.setVisible(false);
            this.startDateHbox.setVisible(true);
            this.endDateHbox.setVisible(true);
            this.frequencyHBox.setVisible(true);
            loadRegions = true;
        } else if (reportName.equalsIgnoreCase("route_profitability") || reportName.equalsIgnoreCase("region_profitability")) {
            loadWarehouses = false;
            loadPostingGroups = false;
            this.dateHbox.setVisible(false);
            this.startDateHbox.setVisible(true);
            this.endDateHbox.setVisible(true);
        } else if (reportName.equalsIgnoreCase("fuel_consumption")) {
            loadWarehouses = false;
            loadPostingGroups = false;
            this.dateHbox.setVisible(false);
            this.startDateHbox.setVisible(true);
            this.endDateHbox.setVisible(true);
        } else if (reportName.equalsIgnoreCase("complete_empty_movement")) {
            loadWarehouses = false;
            loadPostingGroups = false;
            this.dateHbox.setVisible(false);
            this.startDateHbox.setVisible(true);
            this.endDateHbox.setVisible(true);
        } else if (reportName.equalsIgnoreCase("stockanalysis")) {
            loadWarehouses = false;
            this.dateHbox.setVisible(false);
            this.startDateHbox.setVisible(true);
            this.endDateHbox.setVisible(true);
            loadRegions = true;
        } else if (reportName.equalsIgnoreCase("stock_discrepancy")) {
            loadPostingGroups = false;
            loadWarehouses = true;
            this.dateHbox.setVisible(true);
            this.startDateHbox.setVisible(false);
            this.endDateHbox.setVisible(false);
            this.singleWarehouseHbox.setVisible(true);
            this.warehouseHbox.setVisible(false);
        } else if (reportName.equalsIgnoreCase("stockperlocation")) {
            this.loadBrands();
        } else if (reportName.equalsIgnoreCase("countsheet")) {
            this.loadBrands();
        }
        if (loadWarehouses) {
            ObservableList<ShopLocation> warehouses = new ShopLocation().getAllLocations(this.getUser());
            this.warehouse.getItems().addAll(warehouses);
            this.singleWarehouse.setItems(warehouses);
            if (!this.getReportName().equalsIgnoreCase("countsheet")) {
                Platform.runLater(() -> {
                    for (int a = 0; a < warehouses.size(); ++a) {
                        this.warehouse.getCheckModel().check(a);
                    }
                });
            }
        } else {
            this.warehouseHbox.setVisible(false);
        }
        if (loadPostingGroups) {
            ObservableList<PostingGroup> postingGroups = new PostingGroup().getAllPostingGroups(3, this.getUser());
            this.postingGroup.getItems().addAll(postingGroups);
            Platform.runLater(() -> {
                for (int a = 0; a < postingGroups.size(); ++a) {
                    this.postingGroup.getCheckModel().check(a);
                }
            });
        } else {
            this.groupHbox.setVisible(false);
        }
        if (loadRegions) {
            this.loadRegions();
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.regionHBox.managedProperty().bind((ObservableValue)this.regionHBox.visibleProperty());
        this.groupHbox.managedProperty().bind((ObservableValue)this.groupHbox.visibleProperty());
        this.warehouseHbox.managedProperty().bind((ObservableValue)this.warehouseHbox.visibleProperty());
        this.startDateHbox.managedProperty().bind((ObservableValue)this.startDateHbox.visibleProperty());
        this.endDateHbox.managedProperty().bind((ObservableValue)this.endDateHbox.visibleProperty());
        this.singleWarehouseHbox.managedProperty().bind((ObservableValue)this.singleWarehouseHbox.visibleProperty());
        this.frequencyHBox.managedProperty().bind((ObservableValue)this.frequencyHBox.visibleProperty());
        this.dateHbox.managedProperty().bind((ObservableValue)this.dateHbox.visibleProperty());
        this.itemBrandHbox.managedProperty().bind((ObservableValue)this.itemBrandHbox.visibleProperty());
        this.date.setValue((Object)Config.getCurrentLocaldate());
        this.cancelGroup.setOnAction(e -> this.postingGroup.getCheckModel().clearChecks());
        this.cancelWarehouse.setOnAction(e -> this.warehouse.getCheckModel().clearChecks());
        this.cancelRegion.setOnAction(e -> this.region.getCheckModel().clearChecks());
        this.cancelItemBrand.setOnAction(e -> this.itemBrands.getCheckModel().clearChecks());
        ObservableList allFrequencies = FXCollections.observableArrayList();
        allFrequencies.add((Object)"Daily");
        allFrequencies.add((Object)"Weekly");
        allFrequencies.add((Object)"Monthly");
        allFrequencies.add((Object)"Quarterly");
        allFrequencies.add((Object)"Annually");
        this.frequency.setItems(allFrequencies);
        this.frequency.setValue(allFrequencies.get(2));
        this.generate.setOnAction(e -> {
            LinkedHashMap<String, Object> reportParams;
            String reportTitle;
            String dateTo;
            String dateFrom;
            ObservableList selectedRegions = FXCollections.observableArrayList();
            Gson gson = new Gson();
            ArrayList<Integer> selectedPostingGroupCodes = new ArrayList<Integer>();
            ArrayList<Integer> selectedWarehouses = new ArrayList<Integer>();
            try {
                for (Object p : this.postingGroup.getCheckModel().getCheckedItems()) {
                    selectedPostingGroupCodes.add(((PostingGroup)p).getCode());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                for (Object p : this.warehouse.getCheckModel().getCheckedItems()) {
                    selectedWarehouses.add(((ShopLocation)p).getId());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            int selectedSingleWarehouse = 0;
            try {
                selectedSingleWarehouse = ((ShopLocation)this.singleWarehouse.getValue()).getId();
            }
            catch (Exception p) {
                // empty catch block
            }
            String myFrequency = "";
            try {
                myFrequency = ((String)this.frequency.getValue()).trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
            reportVariables.put("saccoName", Config.saccoName);
            params.put("postingGroup", gson.toJson(selectedPostingGroupCodes));
            params.put("warehouse", gson.toJson(selectedWarehouses));
            params.put("singleWarehouse", gson.toJson((Object)selectedSingleWarehouse));
            params.put("frequency", myFrequency);
            try {
                params.put("date", Config.localDateToString((LocalDate)this.date.getValue()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dateFrom = Config.localDateToString((LocalDate)this.startDate.getValue());
            }
            catch (Exception y) {
                dateFrom = "";
            }
            try {
                dateTo = Config.localDateToString((LocalDate)this.endDate.getValue());
            }
            catch (Exception y) {
                dateTo = Config.localDateToString(Config.getCurrentLocaldate());
            }
            try {
                params.put("dateFrom", dateFrom);
            }
            catch (Exception y) {
                // empty catch block
            }
            try {
                params.put("dateTo", dateTo);
            }
            catch (Exception y) {
                // empty catch block
            }
            List<Object> selectedBrands = new ArrayList();
            try {
                selectedBrands = this.itemBrands.getCheckModel().getCheckedItems().stream().map(ItemBrand::getId).collect(Collectors.toList());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                params.put("selectedBrands", new Gson().toJson(selectedBrands));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.getReportName().equalsIgnoreCase("countsheet")) {
                reportVariables.put("reportName", "Count Sheet as At " + Config.localDateToString((LocalDate)this.date.getValue()) + "\nWarehouse(s) : " + this.warehouse.getCheckModel().getCheckedItems().toString());
                new Config().getReport("Count Sheet", "masterfetch?type=countsheet", params, "count_sheet.jasper", reportVariables, this.getUser());
            } else if (this.getReportName().equalsIgnoreCase("price_list")) {
                reportVariables.put("reportTitle", "PRICE LIST ");
                reportVariables.put("address", Config.getShopAddress());
                new Config().getReport("PRICE LIST", "masterfetch?type=price_list", params, "price_list.jasper", reportVariables, this.getUser());
            } else if (this.getReportName().equalsIgnoreCase("product_margins")) {
                reportTitle = "PRODUCT MARGINS";
                if (this.region.getCheckModel().getCheckedItems().size() != this.region.getItems().size()) {
                    ObservableList selected = this.region.getCheckModel().getCheckedItems();
                    reportTitle = "PRODUCT MARGINS " + selected.toString() + " FOR THE PERIOD " + dateFrom + " TO " + dateTo;
                    for (Region mySelection : selected) {
                        selectedRegions.add((Object)mySelection.getId());
                    }
                }
                params.put("selectedRegions", new Gson().toJson((Object)selectedRegions));
                reportVariables.put("reportTitle", reportTitle);
                reportVariables.put("address", Config.getShopAddress());
                new Config().getReport("PRODUCT MARGINS", "masterfetch?type=product_margins", params, "product_margins.jasper", reportVariables, this.getUser());
            } else if (this.getReportName().equalsIgnoreCase("sales_per_sales_rep")) {
                reportVariables.put("reportName", "Sales Per Sales Rep " + dateFrom + " - " + dateTo);
                reportVariables.put("address", Config.getShopAddress());
                new Config().getReport("Sales Per Sales Rep", "masterfetch?type=sales_per_sales_rep", params, "sales_per_sales_rep.jasper", reportVariables, this.getUser());
            } else if (this.getReportName().equalsIgnoreCase("region_sales_report")) {
                reportVariables.put("reportName", "Sales Per Region " + dateFrom + " - " + dateTo);
                reportVariables.put("address", Config.getShopAddress());
                new Config().getReport("Sales Per Region", "masterfetch?type=region_sales", params, "region_sales.jasper", reportVariables, this.getUser());
            } else if (this.getReportName().equalsIgnoreCase("region_sales_per_product")) {
                reportVariables.put("reportName", "Region Sales Per Region " + dateFrom + " - " + dateTo);
                reportVariables.put("address", Config.getShopAddress());
                new Config().getReport("Region Sales Per Region", "masterfetch?type=region_sales_report", params, "region_sales_report.jasper", reportVariables, this.getUser());
            } else if (this.getReportName().equalsIgnoreCase("allassets")) {
                reportVariables.put("address", Config.getShopAddress());
                reportParams = new LinkedHashMap<String, Object>();
                reportParams.put("saccoName", Config.saccoName);
                reportParams.put("reportName", "Fixed Assets Schedule as at " + dateTo);
                new Config().getReport("Fixed Assets Schedule", "masterfetch?type=faschedule", params, "fixedassetsschedule.jasper", reportParams, this.getUser());
            } else if (this.getReportName().equalsIgnoreCase("sales_per_posting_group")) {
                reportTitle = "Sales Per Posting Group " + dateFrom + " to " + dateTo;
                if (this.region.getCheckModel().getCheckedItems().size() != this.region.getItems().size()) {
                    ObservableList selected = this.region.getCheckModel().getCheckedItems();
                    reportTitle = "Sales Per Posting Group " + selected.toString() + " for the period " + dateFrom + " to " + dateTo;
                    for (Region mySelection : selected) {
                        selectedRegions.add((Object)mySelection.getId());
                    }
                }
                params.put("selectedRegions", new Gson().toJson((Object)selectedRegions));
                reportVariables.put("reportName", reportTitle);
                reportVariables.put("address", Config.getShopAddress());
                new Config().getReport("Sales Per Posting Group", "masterfetch?type=sales_per_posting_group", params, "sales_per_posting_group.jasper", reportVariables, this.getUser());
            } else if (this.getReportName().equalsIgnoreCase("route_profitability")) {
                reportVariables.put("reportName", "Route Profitability " + dateFrom + " - " + dateTo);
                reportVariables.put("address", Config.getShopAddress());
                new Config().getReport("Route Profitability", "masterfetch?type=route_profitability", params, "route_profitability.jasper", reportVariables, this.getUser());
            } else if (this.getReportName().equalsIgnoreCase("region_profitability")) {
                reportVariables.put("reportName", "Region Profitability " + dateFrom + " - " + dateTo);
                reportVariables.put("address", Config.getShopAddress());
                new Config().getReport("Region Profitability", "masterfetch?type=region_profitability", params, "region_profitability.jasper", reportVariables, this.getUser());
            } else if (this.getReportName().equalsIgnoreCase("fuel_consumption")) {
                reportVariables.put("reportName", "Fuel, Repairs & Maintenance " + dateFrom + " - " + dateTo);
                reportVariables.put("address", Config.getShopAddress());
                new Config().getReport("Fuel, Repairs & Maintenance", "masterfetch?type=fuel_consumption", params, "fuel_consumption.jasper", reportVariables, this.getUser());
            } else if (this.getReportName().equalsIgnoreCase("complete_empty_movement")) {
                reportVariables.put("reportName", "Complete Empty Movement (Main & Free Warehouses) " + dateFrom + " - " + dateTo);
                reportVariables.put("address", Config.getShopAddress());
                new Config().getReport("Complete Empty Movement", "masterfetch?type=complete_empty_movement", params, "complete_empty_movement.jasper", reportVariables, this.getUser());
            } else if (this.getReportName().equalsIgnoreCase("stockanalysis")) {
                reportParams = new LinkedHashMap();
                reportParams.put("saccoName", Config.saccoName);
                String reportTitle2 = "Stock Movement Analysis " + dateFrom + " to " + dateTo;
                if (this.region.getCheckModel().getCheckedItems().size() != this.region.getItems().size()) {
                    ObservableList selected = this.region.getCheckModel().getCheckedItems();
                    reportTitle2 = "Stock Movement Analysis " + selected.toString() + " FOR THE PERIOD " + dateFrom + " to " + dateTo;
                    for (Region mySelection : selected) {
                        selectedRegions.add((Object)mySelection.getId());
                    }
                }
                params.put("selectedRegions", new Gson().toJson((Object)selectedRegions));
                reportParams.put("reportName", reportTitle2);
                new Config().getReport("Stock Analysis", "masterfetch?type=stockanalysis", params, "stockanalysis.jasper", reportParams, this.user);
            } else if (this.getReportName().equalsIgnoreCase("stock_discrepancy")) {
                reportParams = new LinkedHashMap();
                reportParams.put("saccoName", Config.saccoName);
                reportParams.put("reportName", "Stock Discrepancy Report as at " + Config.localDateToString((LocalDate)this.date.getValue()));
                new Config().getReport("Stock Discrepancy", "masterfetch?type=stock_take_lines", params, "stock_discrepancy.jasper", reportParams, this.user);
            } else {
                reportVariables.put("reportName", "Stock Position as At " + Config.localDateToString((LocalDate)this.date.getValue()));
                new Config().getReport("Stock Per Location", "masterfetch?type=stockperlocation", params, "stock_per_location.jasper", reportVariables, this.getUser());
            }
            ((Stage)this.generate.getScene().getWindow()).close();
        });
    }

    private void loadRegions() {
        if (Config.showRegionReports) {
            this.regionHBox.setVisible(true);
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    Node original = AllItemsFilterController.this.cancelRegion.getGraphic();
                    Platform.runLater(() -> {
                        ProgressIndicator progressIndicator = new ProgressIndicator();
                        progressIndicator.setPrefWidth(20.0);
                        progressIndicator.setPrefHeight(20.0);
                        AllItemsFilterController.this.cancelRegion.setGraphic((Node)progressIndicator);
                    });
                    ObservableList<Region> allRegions = new Region().getAllRegions(AllItemsFilterController.this.getUser());
                    Platform.runLater(() -> {
                        AllItemsFilterController.this.region.getItems().addAll((Collection)FXCollections.observableArrayList((Collection)allRegions));
                        for (int a = 0; a < allRegions.size(); ++a) {
                            AllItemsFilterController.this.region.getCheckModel().check(a);
                        }
                        AllItemsFilterController.this.cancelRegion.setGraphic(original);
                    });
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
        }
    }

    private void loadBrands() {
        this.itemBrandHbox.setVisible(true);
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Node original = AllItemsFilterController.this.cancelItemBrand.getGraphic();
                Platform.runLater(() -> {
                    ProgressIndicator progressIndicator = new ProgressIndicator();
                    progressIndicator.setPrefWidth(20.0);
                    progressIndicator.setPrefHeight(20.0);
                    AllItemsFilterController.this.cancelItemBrand.setGraphic((Node)progressIndicator);
                });
                ObservableList allBrands = FXCollections.observableArrayList(new ItemBrand().getAllBrands(AllItemsFilterController.this.getUser()));
                Platform.runLater(() -> {
                    AllItemsFilterController.this.itemBrands.getItems().addAll((Collection)allBrands);
                    for (int a = 0; a < allBrands.size(); ++a) {
                        AllItemsFilterController.this.itemBrands.getCheckModel().check(a);
                    }
                    AllItemsFilterController.this.cancelItemBrand.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }
}

