/*
 * Decompiled with CFR 0.152.
 */
package filterscontrollers;

import classes.Config;
import classes.LoanProduct;
import classes.Member;
import classes.User;
import java.net.URL;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.stage.Stage;

public class AllLoansStatement
implements Initializable {
    private User user;
    @FXML
    private ComboBox<Member> member;
    @FXML
    private ComboBox<LoanProduct> loanProduct;
    @FXML
    private DatePicker issuedFrom;
    @FXML
    private DatePicker issuedTo;
    @FXML
    private Button generate;
    @FXML
    private Button chooseMember;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.chooseMember.setOnAction(e -> {
            try {
                Member me = new Member().getMemberFromSelection(this.getUser());
                if (me.getMemberNumber().length() > 0) {
                    this.member.setValue((Object)me);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.member.setItems(new Member().getAllMembers(this.getUser()));
        this.loanProduct.setItems(new LoanProduct().getAllLoanProducts(this.getUser()));
        this.generate.setOnAction(e -> {
            String tMember = "";
            try {
                tMember = ((Member)this.member.getValue()).getMemberNumber();
            }
            catch (Exception y) {
                tMember = "";
            }
            String tProductCode = "";
            try {
                tProductCode = ((LoanProduct)this.loanProduct.getValue()).getLoanProductCode();
            }
            catch (Exception y) {
                tProductCode = "";
            }
            String tIssuedFrom = "";
            try {
                tIssuedFrom = Config.localDateToString((LocalDate)this.issuedFrom.getValue());
            }
            catch (Exception y) {
                tIssuedFrom = "";
            }
            String tIssuedTo = "";
            try {
                tIssuedTo = Config.localDateToString((LocalDate)this.issuedTo.getValue());
            }
            catch (Exception y) {
                tIssuedTo = "";
            }
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("issued", 1);
                params.put("memberNumber", tMember);
                params.put("productCode", tProductCode);
                params.put("issuedFrom", tIssuedFrom);
                params.put("issuedTo", tIssuedTo);
                HashMap<String, Object> parameters2 = new HashMap<String, Object>();
                parameters2.put("saccoName", Config.saccoName);
                new Config().getReport("Loan Statement", "masterfetch?type=loans", params, "allloans.jasper", parameters2, this.getUser());
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your report. Please contact support");
                alert.showAndWait();
            }
            Stage stage = (Stage)this.generate.getScene().getWindow();
            stage.close();
        });
    }
}

