/*
 * Decompiled with CFR 0.152.
 */
package filterscontrollers;

import classes.Bank;
import classes.Config;
import classes.Member;
import classes.User;
import java.net.URL;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.stage.Stage;

public class AllReceiptsFilter
implements Initializable {
    private User user;
    @FXML
    private ComboBox<Member> member;
    @FXML
    private ComboBox<Bank> bank;
    @FXML
    private DatePicker receiptFrom;
    @FXML
    private DatePicker receiptTo;
    @FXML
    private Button generate;
    @FXML
    private Button chooseMember;
    @FXML
    private CheckBox postedReceipts;
    @FXML
    private CheckBox reversedReceipts;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.chooseMember.setOnAction(e -> {
            try {
                Member me = new Member().getMemberFromSelection(this.getUser());
                if (me.getMemberNumber().length() > 0) {
                    this.member.setValue((Object)me);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.member.setItems(new Member().getAllMembers(this.getUser()));
        this.bank.setItems(Bank.getAllBanks(this.getUser()));
        this.generate.setOnAction(e -> {
            String tMember = "";
            try {
                tMember = ((Member)this.member.getValue()).getMemberNumber();
            }
            catch (Exception y) {
                tMember = "";
            }
            int bankCode = 0;
            try {
                bankCode = ((Bank)this.bank.getValue()).getCode();
            }
            catch (Exception y) {
                bankCode = 0;
            }
            String tReceiptFrom = "";
            try {
                tReceiptFrom = Config.localDateToString((LocalDate)this.receiptFrom.getValue());
            }
            catch (Exception y) {
                tReceiptFrom = "";
            }
            String tReceiptTo = "";
            try {
                tReceiptTo = Config.localDateToString((LocalDate)this.receiptTo.getValue());
            }
            catch (Exception y) {
                tReceiptTo = "";
            }
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("issued", 1);
                params.put("memberNumber", tMember);
                params.put("bankCode", bankCode);
                params.put("receiptFrom", tReceiptFrom);
                params.put("tReceiptTo", tReceiptTo);
                params.put("posted", this.postedReceipts.isSelected() ? 1 : 0);
                params.put("reversed", this.reversedReceipts.isSelected() ? 1 : 0);
                HashMap<String, Object> parameters2 = new HashMap<String, Object>();
                parameters2.put("saccoName", Config.saccoName);
                new Config().getReport("All Receipts", "masterfetch?type=memberreceipts", params, "allreceipts.jasper", parameters2, this.getUser());
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your report. Please contact support");
                alert.showAndWait();
            }
            Stage stage = (Stage)this.generate.getScene().getWindow();
            stage.close();
        });
    }
}

