/*
 * Decompiled with CFR 0.152.
 */
package filterscontrollers;

import classes.Bank;
import classes.Config;
import classes.User;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class BankStatementFilter
implements Initializable {
    private User user;
    Bank myBank;
    @FXML
    private ComboBox<Bank> bank;
    @FXML
    private TextField chequeNumber;
    @FXML
    private DatePicker from;
    @FXML
    private DatePicker to;
    @FXML
    private Button generate;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.bank.setItems(Bank.getAllBanks(this.getUser()));
    }

    public Bank getMyBank() {
        return this.myBank;
    }

    public void setMyBank(Bank myBank) {
        this.myBank = myBank;
        this.bank.setValue((Object)myBank);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.generate.setOnAction(e -> {
            try {
                Bank myBank = null;
                try {
                    myBank = (Bank)this.bank.getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String tChequeNumber = "";
                String tFrom = "";
                String tTo = "";
                try {
                    tChequeNumber = this.chequeNumber.getText().trim();
                }
                catch (Exception u) {
                    tChequeNumber = "";
                }
                try {
                    tFrom = Config.localDateToString((LocalDate)this.from.getValue());
                }
                catch (Exception u) {
                    tFrom = "";
                }
                try {
                    tTo = Config.localDateToString((LocalDate)this.to.getValue());
                }
                catch (Exception u) {
                    tTo = "";
                }
                LinkedHashMap<String, Object> dataParams = new LinkedHashMap<String, Object>();
                dataParams.put("bankCode", myBank.getCode());
                dataParams.put("chequeNumber", tChequeNumber);
                dataParams.put("from", tFrom);
                dataParams.put("to", tTo);
                LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>();
                reportParams.put("saccoName", Config.saccoName);
                reportParams.put("bankName", myBank.getBankName());
                reportParams.put("bankBranch", myBank.getBankBranch());
                reportParams.put("bankAccount", myBank.getBankAccount());
                new Config().getReport("Bank Statement", "masterfetch?type=bankstatement", dataParams, "bankstatement.jasper", reportParams, this.getUser());
            }
            catch (Exception myBank) {
                // empty catch block
            }
            Stage stage = (Stage)this.generate.getScene().getWindow();
            stage.close();
        });
    }
}

