/*
 * Decompiled with CFR 0.152.
 */
package filterscontrollers;

import classes.Account;
import classes.Config;
import classes.User;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;

public class GLAccountFilter
implements Initializable {
    private User user;
    Account account;
    private String reportName;
    @FXML
    private HBox glHbox;
    @FXML
    private ComboBox<Account> glAccount;
    @FXML
    private DatePicker from;
    @FXML
    private DatePicker to;
    @FXML
    private Button generate;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
        this.account = account;
        this.glAccount.setValue((Object)account);
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
        if (reportName.equalsIgnoreCase("trialbalance")) {
            this.glHbox.setVisible(false);
        }
        if (reportName.equalsIgnoreCase("generalledger")) {
            this.glHbox.setVisible(false);
        }
        if (reportName.equalsIgnoreCase("accountstatement")) {
            this.glAccount.setItems(Account.getAccounts(this.getUser()));
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.glHbox.managedProperty().bind((ObservableValue)this.glHbox.visibleProperty());
        this.generate.setOnAction(e -> {
            try {
                String period;
                Account myAccount = null;
                try {
                    myAccount = (Account)this.glAccount.getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String tFrom = "";
                String tTo = "";
                try {
                    tFrom = Config.localDateToString((LocalDate)this.from.getValue());
                }
                catch (Exception u) {
                    tFrom = "";
                }
                try {
                    tTo = Config.localDateToString((LocalDate)this.to.getValue());
                }
                catch (Exception u) {
                    tTo = "";
                }
                String accountNo = "";
                try {
                    accountNo = ((Account)this.glAccount.getValue()).getAccountNumber();
                }
                catch (Exception p) {
                    accountNo = "";
                }
                LinkedHashMap<String, Object> dataParams = new LinkedHashMap<String, Object>();
                dataParams.put("accountNumber", accountNo);
                dataParams.put("from", tFrom);
                dataParams.put("to", tTo);
                String string = period = tFrom.length() > 0 ? " For the Period " + tFrom : "";
                period = period.length() > 0 ? period + (tTo.length() > 0 ? " to " + tTo : " to " + Config.localDateToString(Config.getCurrentLocaldate())) : period + (tTo.length() > 0 ? " For the Period to " + tFrom : "");
                if (this.getReportName().equalsIgnoreCase("accountstatement")) {
                    LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>();
                    reportParams.put("saccoName", Config.saccoName);
                    reportParams.put("glAccount", ((Account)this.glAccount.getValue()).getAccountName());
                    reportParams.put("period", period);
                    new Config().getReport("G/L Account Statement", "masterfetch?type=glentries", dataParams, "accountstatement.jasper", reportParams, this.getUser());
                } else if (this.getReportName().equalsIgnoreCase("trialbalance")) {
                    LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>();
                    reportParams.put("saccoName", Config.saccoName);
                    reportParams.put("reportName", "TRIAL BALANCE  " + (period.length() > 0 ? " FOR THE PERIOD " + period.toUpperCase() : ""));
                    reportParams.put("period", period);
                    new Config().getReport("Trial Balance", "masterfetch?type=trialbalance", dataParams, "trialbalance.jasper", reportParams, this.getUser());
                } else if (this.getReportName().equalsIgnoreCase("generalledger")) {
                    LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>();
                    reportParams.put("saccoName", Config.saccoName);
                    reportParams.put("reportName", "General Ledger " + period);
                    reportParams.put("period", period);
                    new Config().getReport("General Ledger", "masterfetch?type=generalledger", dataParams, "generalledger.jasper", reportParams, this.getUser());
                }
            }
            catch (Exception myAccount) {
                // empty catch block
            }
            Stage stage = (Stage)this.generate.getScene().getWindow();
            stage.close();
        });
    }
}

