/*
 * Decompiled with CFR 0.152.
 */
package filterscontrollers;

import classes.Config;
import classes.Month;
import classes.User;
import classes.Year;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.stage.Stage;

public class LoanMonthlyRepayment
implements Initializable {
    private User user;
    @FXML
    private ComboBox<Year> year;
    @FXML
    private Button generate;
    @FXML
    private ComboBox<Month> month;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.year.setItems(new Year().getAllYears(this.getUser()));
        this.month.setItems(new Month().getAllMonths());
        LocalDate today = LocalDate.now();
        Year current = new Year();
        current.setYear(today.getYear());
        this.year.setValue((Object)current);
        for (Month myMonth : this.month.getItems()) {
            if (myMonth.getCode() != today.getMonthValue()) continue;
            this.month.setValue((Object)myMonth);
        }
        this.generate.setOnAction(e -> {
            LinkedHashMap<String, Object> dataParams = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>();
            int monthCode = 0;
            String monthName = "";
            boolean yearCode = false;
            try {
                monthCode = ((Month)this.month.getValue()).getCode();
                monthName = ((Month)this.month.getValue()).getMonthName();
            }
            catch (Exception u) {
                monthCode = 0;
            }
            dataParams.put("month", monthCode);
            reportParams.put("month", monthName);
            try {
                int myYear = ((Year)this.year.getValue()).getYear();
                dataParams.put("year", myYear);
                reportParams.put("year", myYear);
            }
            catch (Exception myYear) {
                // empty catch block
            }
            reportParams.put("saccoName", Config.saccoName);
            new Config().getReport("Monthly Loan Repayment", "masterfetch?type=loanrepaymentperperiod", dataParams, "loanmonthlyrepayment.jasper", reportParams, this.getUser());
            Stage stage = (Stage)this.generate.getScene().getWindow();
            stage.close();
        });
    }
}

