/*
 * Decompiled with CFR 0.152.
 */
package filterscontrollers;

import classes.Config;
import classes.Month;
import classes.User;
import classes.Year;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class MasterRollFilter
implements Initializable {
    private User user;
    private String reportName = "masterroll";
    @FXML
    private ComboBox<Year> year;
    @FXML
    private Button generate;
    @FXML
    private ComboBox<Month> month;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.year.setItems(new Year().getAllYears(user));
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.month.setItems(new Month().getAllMonths());
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.month, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.year, Validator.createEmptyValidator((String)"Required"));
        this.generate.setOnAction(e -> {
            boolean error = false;
            String message = "";
            int monthCode = 0;
            int yearCode = 0;
            try {
                monthCode = ((Month)this.month.getValue()).getCode();
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select the month";
            }
            try {
                yearCode = ((Year)this.year.getValue()).getYear();
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select the year";
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("month", monthCode);
                params.put("year", yearCode);
                LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                reportVariables.put("saccoName", Config.saccoName);
                reportVariables.put("reportName", "Master Roll For The Period " + ((Month)this.month.getValue()).getMonthName() + " " + ((Year)this.year.getValue()).getYear());
                Stage stage = (Stage)this.generate.getScene().getWindow();
                switch (this.reportName) {
                    case "masterroll": {
                        new Config().getReport("Master Roll", "masterfetch?type=masterroll", params, "masterroll.jasper", reportVariables, this.user);
                        stage.close();
                        return;
                    }
                    case "bank_export": {
                        this.getBankExport(stage, params, this.getUser());
                        return;
                    }
                    case "paye_export": {
                        this.getPAYEExport(stage, params, this.getUser());
                        return;
                    }
                    case "nhif_export": {
                        this.getNHIFExport(stage, params, this.getUser());
                        return;
                    }
                    case "nssf_export": {
                        this.getNSSFExport(stage, params, this.getUser());
                        return;
                    }
                }
            }
        });
    }

    public void getBankExport(Stage stage, Map<String, Object> params, User user) {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Excel Files (*.xlsx)", new String[]{"*.xlsx"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        File file = fileChooser.showSaveDialog((Window)stage);
        if (file != null) {
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet("Master Roll");
            int rowCount = 0;
            int columnCount = 0;
            XSSFRow row = sheet.createRow(rowCount++);
            row.createCell(columnCount++).setCellValue("Customer Reference No");
            row.createCell(columnCount++).setCellValue("Beneficiary Name");
            row.createCell(columnCount++).setCellValue("Beneficiary Bank Code / SWIFT Code");
            row.createCell(columnCount++).setCellValue("BranchCode");
            row.createCell(columnCount++).setCellValue("Beneficiary Account No.");
            row.createCell(columnCount++).setCellValue("Payment Amount");
            row.createCell(columnCount++).setCellValue("Transaction Type Code");
            row.createCell(columnCount++).setCellValue("Purpose Of Payment");
            row.createCell(columnCount++).setCellValue("Beneficiary Addr. Line 1");
            row.createCell(columnCount++).setCellValue("Charge Type");
            row.createCell(columnCount++).setCellValue("Transaction Currency");
            row.createCell(columnCount++).setCellValue("Payment Type");
            String response = Config.loadDataFromPhp("masterfetch?type=bankexport", params, user);
            System.out.println("Bank Export" + response);
            ObservableList tResponse = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, Map[].class)));
            for (Map current : tResponse) {
                columnCount = 0;
                XSSFRow row2 = sheet.createRow(rowCount++);
                row2.createCell(columnCount++).setCellValue(current.get("employeeNo").toString());
                row2.createCell(columnCount++).setCellValue(current.get("employeeName").toString());
                try {
                    row2.createCell(columnCount++).setCellValue(current.get("bankCode").toString());
                }
                catch (Exception i) {
                    row2.createCell(columnCount++).setCellValue("");
                }
                try {
                    try {
                        row2.createCell(columnCount++).setCellValue(current.get("branchCode").toString());
                    }
                    catch (Exception u) {
                        row2.createCell(columnCount).setCellValue("");
                    }
                    try {
                        row2.createCell(columnCount++).setCellValue(current.get("accountNumber").toString());
                    }
                    catch (Exception u) {
                        row2.createCell(columnCount).setCellValue("");
                    }
                    try {
                        row2.createCell(columnCount++).setCellValue(current.get("netPay").toString());
                    }
                    catch (Exception u) {
                        row2.createCell(columnCount).setCellValue("");
                    }
                    try {
                        row2.createCell(columnCount++).setCellValue(current.get("transactionTypeCode").toString());
                    }
                    catch (Exception u) {
                        row2.createCell(columnCount).setCellValue("");
                    }
                    try {
                        row2.createCell(columnCount++).setCellValue(current.get("purposeOfPayment").toString());
                    }
                    catch (Exception u) {
                        row2.createCell(columnCount).setCellValue("");
                    }
                    try {
                        row2.createCell(columnCount++).setCellValue(current.get("addressLine").toString());
                    }
                    catch (Exception u) {
                        row2.createCell(columnCount).setCellValue("");
                    }
                    try {
                        row2.createCell(columnCount++).setCellValue(current.get("chargeType").toString());
                    }
                    catch (Exception u) {
                        row2.createCell(columnCount).setCellValue("");
                    }
                    try {
                        row2.createCell(columnCount++).setCellValue(current.get("transactionCurrency").toString());
                    }
                    catch (Exception u) {
                        row2.createCell(columnCount).setCellValue("");
                    }
                    try {
                        row2.createCell(columnCount++).setCellValue(current.get("paymentType").toString());
                    }
                    catch (Exception u) {
                        row2.createCell(columnCount).setCellValue("");
                    }
                }
                catch (Exception i) {
                    i.printStackTrace();
                }
            }
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                workbook.write((OutputStream)outputStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.close();
        }
    }

    public void getPAYEExport(Stage stage, Map<String, Object> params, User user) {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Excel Files (*.xlsx)", new String[]{"*.xlsx"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        File file = fileChooser.showSaveDialog((Window)stage);
        if (file != null) {
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet("Sheet 1");
            int rowCount = 0;
            int columnCount = 0;
            String response = Config.loadDataFromPhp("masterfetch?type=payeexport", params, user);
            System.out.println("Paye " + response);
            ObservableList tResponse = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, Map[].class)));
            for (Map current : tResponse) {
                XSSFRow row = sheet.createRow(rowCount++);
                for (Map.Entry entry : current.entrySet()) {
                    row.createCell(columnCount++).setCellValue(entry.getValue().toString());
                }
                columnCount = 0;
            }
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                workbook.write((OutputStream)outputStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.close();
        }
    }

    public void getNHIFExport(Stage stage, Map<String, Object> params, User user) {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Excel Files (*.xlsx)", new String[]{"*.xlsx"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        File file = fileChooser.showSaveDialog((Window)stage);
        if (file != null) {
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet("Sheet 1");
            int rowCount = 0;
            int columnCount = 0;
            String response = Config.loadDataFromPhp("masterfetch?type=nhifexport", params, user);
            ObservableList tResponse = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, Map[].class)));
            for (Map current : tResponse) {
                XSSFRow row = sheet.createRow(rowCount++);
                for (Map.Entry entry : current.entrySet()) {
                    System.out.println("Key = " + (String)entry.getKey() + ", Value = " + entry.getValue().toString());
                    row.createCell(columnCount++).setCellValue(entry.getValue().toString());
                }
                columnCount = 0;
            }
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                workbook.write((OutputStream)outputStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.close();
        }
    }

    public void getNSSFExport(Stage stage, Map<String, Object> params, User user) {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Excel Files (*.xlsx)", new String[]{"*.xlsx"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        File file = fileChooser.showSaveDialog((Window)stage);
        if (file != null) {
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet("Sheet 1");
            int rowCount = 0;
            int columnCount = 0;
            String response = Config.loadDataFromPhp("masterfetch?type=nssfexport", params, user);
            ObservableList tResponse = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, Map[].class)));
            for (Map current : tResponse) {
                XSSFRow row = sheet.createRow(rowCount++);
                for (Map.Entry entry : current.entrySet()) {
                    System.out.println("Key = " + (String)entry.getKey() + ", Value = " + entry.getValue().toString());
                    row.createCell(columnCount++).setCellValue(entry.getValue().toString());
                }
                columnCount = 0;
            }
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                workbook.write((OutputStream)outputStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.close();
        }
    }
}

