/*
 * Decompiled with CFR 0.152.
 */
package filterscontrollers;

import classes.Config;
import classes.Month;
import classes.User;
import classes.VehicleBrands;
import classes.Year;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.stage.Stage;
import org.controlsfx.control.CheckComboBox;

public class VehicleMonthlyArrears
implements Initializable {
    private User user;
    @FXML
    private ComboBox<Year> year;
    @FXML
    private Button generate;
    @FXML
    private ComboBox<Month> month;
    @FXML
    private CheckBox includeInactive;
    @FXML
    private CheckBox includeExited;
    @FXML
    private CheckComboBox<VehicleBrands> brands;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.month.setItems(new Month().getAllMonths());
        this.month.setValue((Object)new Month().getCurrentMonth());
        this.year.setItems(new Year().getAllYears(this.getUser()));
        this.year.setValue((Object)new Year().getCurrentYear());
        this.brands.getItems().addAll(new VehicleBrands().getAllBrands(this.getUser()));
    }

    public void initialize(URL location, ResourceBundle resources) {
        int count = this.brands.getItems().size();
        int a = 0;
        while (a < count) {
            this.brands.getCheckModel().checkIndices(new int[]{a++});
        }
        this.generate.setOnAction(e -> {
            try {
                String myBrands = "";
                String filterName = "";
                ObservableList selectedBrands = this.brands.getCheckModel().getCheckedItems();
                for (VehicleBrands brand : selectedBrands) {
                    myBrands = myBrands + (myBrands.length() > 0 ? "," : "");
                    myBrands = myBrands + brand.getBrandId() + "";
                    filterName = filterName + (filterName.length() > 0 ? ", " : "Under ");
                    filterName = filterName + brand.getBrandName() + "";
                }
                if (selectedBrands.size() == this.brands.getItems().size()) {
                    filterName = "";
                }
                filterName = filterName + " for the Period " + ((Month)this.month.getValue()).getMonthName() + " " + ((Year)this.year.getValue()).getYear();
                LinkedHashMap<String, Object> dataParams = new LinkedHashMap<String, Object>();
                dataParams.put("brand", myBrands);
                dataParams.put("year", ((Year)this.year.getValue()).getYear());
                dataParams.put("month", ((Month)this.month.getValue()).getCode());
                dataParams.put("inactive", this.includeInactive.isSelected() ? 1 : 0);
                dataParams.put("exited", this.includeExited.isSelected() ? 1 : 0);
                LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>();
                reportParams.put("saccoName", Config.saccoName);
                reportParams.put("filterName", filterName);
                reportParams.put("monthName", ((Month)this.month.getValue()).getMonthName());
                new Config().getReport("All Vehicles Monthly Arrears", "masterfetch?type=allvehiclesmonthly", dataParams, "allvehiclesmonthly.jasper", reportParams, this.getUser());
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your report. Please contact support");
                alert.showAndWait();
            }
            Stage stage = (Stage)this.generate.getScene().getWindow();
            stage.close();
        });
    }
}

